/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	storage and retrieval of the preferences file
 */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "xtrojka.h"
#include "prefs.h"

extern flag is_score_status;
extern flag is_auto_position;
extern flag is_wizard;
extern int speed, oldspeed;
PREFS prefs;

extern char *getenv();

char prefsfile[300];

init_prefs()
{
	/* try to read the prefs from the file */
	if(getenv(HOME_ENV) == NULL) {
		strcpy(prefsfile,"/tmp/huh_huh");
		return 0;
	}
	sprintf(prefsfile,"%s/%s", getenv(HOME_ENV), PREFSFILE);
}


read_prefs()
{
	int fd;

	/* set the default preferences */
	is_score_status = 1;
	is_auto_position = 1;
	is_wizard = 0;
	oldspeed = speed = 5;

	if((fd = open(prefsfile, O_RDONLY)) < 0) {
		create_prefsfile();
		write_prefs();
		return 0;
	} else
	if(read(fd, &prefs, sizeof(prefs)) < 0) {
		return 0;
	}
	
	is_score_status = prefs.score_status;
	is_wizard = prefs.wizard;
	is_auto_position = prefs.auto_position;
	oldspeed = speed = prefs.speed;

	close(fd);
}


write_prefs()
{
	int fd;

	/* try to write the prefs to the prefsfile */
	
	if((fd = open(prefsfile, O_WRONLY)) < 0) {
		fprintf(stderr,"write_prefs: cannot open preferences\n");
		exit(1);
	}

	prefs.score_status = is_score_status;
	prefs.auto_position = is_auto_position;
	prefs.wizard = is_wizard;
	prefs.speed = speed;

	if(write(fd, &prefs, sizeof(prefs)) < 0) {
		fprintf(stderr,"write_prefs: cannot write preferences\n");
		exit(1);
	}
}

int create_prefsfile()
{
	int fd;
	int oldumask = umask(0);

	if((fd = creat(prefsfile, 0666)) < 0) {
		fprintf(stderr,"cannot create prefsfile: %s\n", prefsfile);
		exit(1);
	}
	close(fd);
	
	umask(oldumask);
}

