/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	this system deals with updating of exposed regions
 */


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "xtrojka.h"
#include "resource.h"
#include "screen.h"

extern Widget screen, score_status_screen;
extern Widget leftpillar, rightpillar;
extern Widget about_screen;

extern Pixel black_pix;
extern Pixel white_pix;

Pixmap leftpillarPic, rightpillarPic;

extern flag is_color;

void redraw_leftpillar_hlr();
void redraw_rightpillar_hlr();
void redraw_field_hlr();
void redraw_title_hlr();
void redraw_score_status_hlr();
void redraw_about_hlr();


void set_redraw_handlers(gs)
enum gamestate gs;
{
	/* set handler for score_status window */
	XtAddEventHandler(score_status_screen, ExposureMask, False,
		redraw_score_status_hlr, (Opaque)NULL);
	


	/* set handlers for redraw events */
	if(gs == st_playing) {
		XtRemoveEventHandler(screen, ExposureMask, False,
			redraw_title_hlr, (Opaque)NULL);
		XtAddEventHandler(screen, ExposureMask, False,
			redraw_field_hlr, (Opaque)NULL
		);
/* add handler to redraw score */
	} else {
		XtRemoveEventHandler(screen, ExposureMask, False,
			redraw_field_hlr, (Opaque)NULL);
		XtAddEventHandler(screen, ExposureMask, False,
			redraw_title_hlr, (Opaque)NULL);
	}
}


set_pillar_redraw_handler()
{
	XtAddEventHandler(leftpillar, ExposureMask, False,
		redraw_leftpillar_hlr, (Opaque)NULL
	);

	XtAddEventHandler(rightpillar, ExposureMask, False,
		redraw_rightpillar_hlr, (Opaque)NULL
	);
}



void redraw_leftpillar_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	if(is_color) {
		set_color(leftpillar, BLACK, WHITE);
		XCopyPlane(XtDisplay(leftpillar), leftpillarPic,
			XtWindow(leftpillar),
			DefaultGCOfScreen(XtScreen(leftpillar)),
			0,0, PILLAR_XSIZE, PILLAR_YSIZE, 0,0, 1);
	} else {
		XCopyArea(XtDisplay(leftpillar), leftpillarPic,
			XtWindow(leftpillar),
			DefaultGCOfScreen(XtScreen(leftpillar)),
			0,0, PILLAR_XSIZE, PILLAR_YSIZE, 0,0);
	}
}


void redraw_rightpillar_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;
	
	if(is_color) {
		set_color(rightpillar, BLACK, WHITE);
		XCopyPlane(XtDisplay(rightpillar), rightpillarPic,
			XtWindow(rightpillar),
			DefaultGCOfScreen(XtScreen(rightpillar)),
			0,0, PILLAR_XSIZE, PILLAR_YSIZE, 0,0, 1);
	} else {
		XCopyArea(XtDisplay(rightpillar), rightpillarPic,
			XtWindow(rightpillar),
			DefaultGCOfScreen(XtScreen(rightpillar)),
			0,0, PILLAR_XSIZE, PILLAR_YSIZE, 0,0);
	}
}

void redraw_field_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	draw_field();
}


void redraw_title_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	draw_title();
}


void redraw_score_status_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	draw_score_status(kFORCED);
}

void redraw_about_hlr(w, unused, xexp, continue_to_dispatch)
Widget w;
XExposeEvent *xexp;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	draw_about();
}
