/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	read in the picture data
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xtrojka.h"
#include "resource.h"

#include "bitmaps/block0"		
#include "bitmaps/block1"
#include "bitmaps/block2"		
#include "bitmaps/block3"		
#include "bitmaps/block4"
#include "bitmaps/block5"
#include "bitmaps/leftpillar"
#include "bitmaps/rightpillar"
#include "bitmaps/new"
#include "bitmaps/title"
#include "bitmaps/icon"

extern Pixmap blockPic[BLOCKS + 1];
extern Pixmap newPic, titlePic;
extern Pixmap leftpillarPic, rightpillarPic;

extern Widget main_screen;
extern Widget screen;
extern flag is_color;

Pixel black_pix, white_pix;
Pixmap app_icon;

GC field_gc;
Display *field_d;
Screen *field_scr;


void make_bitmaps()
{
	int i;

	black_pix = BlackPixel(XtDisplay(main_screen), 0);
	white_pix = WhitePixel(XtDisplay(main_screen), 0);

#ifdef SIZEOF_WINE
	field_d = (Display*)malloc(sizeof(unsigned long));
#else
	field_d = (Display*)malloc(sizeof(Display));
#endif
	field_scr = (Screen*)malloc(sizeof(Screen));
	
	if(!field_d || !field_scr) {
		fprintf(stderr,"make_bitmaps: Not enough memory\n");
		exit(1);
	}

	field_d = XtDisplay(screen);
	field_scr = XtScreen(screen);
	field_gc = DefaultGCOfScreen(field_scr);

	app_icon = XCreateBitmapFromData(XtDisplay(main_screen),
		RootWindowOfScreen(XtScreen(main_screen)),
		icon_bits, icon_width, icon_height);

	if(is_color) {
		/* read the pillars */

		/* left pillar */
		leftpillarPic = XCreatePixmapFromBitmapData(
			XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			leftpillar_bits, leftpillar_width, leftpillar_height,
			black_pix, white_pix, 1);

		/* right pillar */
		rightpillarPic = XCreatePixmapFromBitmapData(
			XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			rightpillar_bits,rightpillar_width,rightpillar_height,
			black_pix, white_pix, 1);

		newPic = XCreatePixmapFromBitmapData(
			XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			new_bits,new_width,new_height,
			black_pix, white_pix, 1);

		titlePic = XCreatePixmapFromBitmapData(
			XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			title_bits,title_width,title_height,
			black_pix, white_pix, 1);
	} else {

		/* block 0 */
		blockPic[0] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block0_bits, block0_width, block0_height);

		/* block 1 */
		blockPic[1] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block1_bits, block1_width, block1_height);

		/* block 2 */
		blockPic[2] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block2_bits, block2_width, block2_height);

		/* block 3 */
		blockPic[3] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block3_bits, block3_width, block3_height);

		/* block 4 */
		blockPic[4] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block4_bits, block4_width, block4_height);

		/* block 5 */
		blockPic[5] = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			block5_bits, block5_width, block5_height);
	/* read the pillars */

		/* left pillar */
		leftpillarPic = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			leftpillar_bits, leftpillar_width, leftpillar_height);

		/* right pillar */
		rightpillarPic = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			rightpillar_bits,rightpillar_width,rightpillar_height);

		/* "new" picture */
		newPic = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			new_bits,new_width,new_height);

		/* the title picture */
		titlePic = XCreateBitmapFromData(XtDisplay(main_screen),
			RootWindowOfScreen(XtScreen(main_screen)),
			title_bits, title_width, title_height);
	}
}
