/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	scan the blocks for patterns to wipe
 */

#include "xtrojka.h"

extern unsigned long
	score,
	wipes;

extern int
	field[VIRT_XSIZE][VIRT_YSIZE];


char	f[VIRT_XSIZE][VIRT_YSIZE];
	/* shadow matrix, where 'tagged' blocks are kept */

flag is_gaps;

int stacklevel;		/* only used here */


int scan()
{

	int wipe_bonus, wipe_count, wiped;

	wipe_bonus = 1;
	wipe_count = 0;
	reset_f();

	while((wiped = fieldscan()) > 0) {

		shiftblocks();

		wipe_bonus *= 2;
		score += (unsigned long)(wipe_bonus * wiped * 10);

		wipe_count++;
		if(((int)wipe_count % TROJKA) == 0)
			score += 3333L;
		wipes++;
	}
	is_gaps = has_gaps();
	return(stacklevel);
}


int fieldscan()
{
	int x, y, wiped, left, right;

	stacklevel = getstacklevel();
	wiped = 0;

	left = 0 + 1;
	right = VIRT_XSIZE - 1;
	for(x = left; x < right; x++)
	    for(y = stacklevel; y >= PLM_BOTTOM; y--) {
		if(field[x][y] > 0) {
/* "\" */		if ((field[x-1][y-1] == field[x][y])
			&& (field[x][y] == field[x+1][y+1])) {
				f[x-1][y-1] = f[x+1][y+1] = f[x][y] = TAGGED;
				wiped++;
			}
/* "/" */		if ((field[x-1][y+1] == field[x][y])
			&& (field[x][y] == field[x+1][y-1])) {
				f[x-1][y+1] = f[x][y] = f[x+1][y-1] = TAGGED;
				wiped++;
			}
/* "--" */		if ((field[x-1][y] == field[x][y])
			&& (field[x][y] == field[x+1][y])) {
				f[x-1][y] = f[x+1][y] = f[x][y] = TAGGED;
				wiped++;
			}
		}
	    }
	return(wiped * 3);
}


int has_gaps()
{
	int x,y;
	flag gap_found;

	for(x = 0; x < VIRT_XSIZE; x++) {
		gap_found = 0;
		for(y = PLM_BOTTOM; y < stacklevel; y++) {
			if((field[x][y] > 0) && (gap_found))
				return 1;
			else if(field[x][y] == 0)
				gap_found = 1;
		}
	}
	return 0;
}

int shiftblocks()
{
	int x, y;

	for(x = 0; x < VIRT_XSIZE; x++)
		for(y = stacklevel; y > 0; y--)
			if(f[x][y] == TAGGED) {
				explode(x,y);
				shiftdown(x, y);
				f[x][y] = CLEAR;
			}
}


int shiftdown(x, y)			/* both visual and virtual */
int x, y;
{
	while(field[x][y] != CLEAR) {
		field[x][y] = field[x][y+1];
		makeblock(x, y, field[x][y]);
		y++;
	}
}


int explode(x, y)
int x, y;
{
	wipeblock(x,y);
}


int getstacklevel()
/* returns the last empty line in the virtual field */
{
	int y = PLM_TOP;

	while(isempty(y))
		y--;
	return(y);
}


int isempty(y)
int y;
{
	int x;

	for(x = 0; x < VIRT_XSIZE; x++)
		if(field[x][y] != CLEAR)
			return 0;
	return 1;
}


int reset_f()
{
	int x,y;

	for(x = 0; x < VIRT_XSIZE;x++)
		for(y = 0; y < VIRT_YSIZE;y++)
			f[x][y] = CLEAR;
}
