/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	manages the score_status display
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <signal.h>
#include <pwd.h>

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>

#include "xtrojka.h"
#include "hiscore.h"
#include "resource.h"


#define YPOS(y)	(((y)+1)*18)
#define XPOS 30
#define SCORE_STATUS_TIMEOUT	5000		/* millisecs */

extern Widget score_status_screen;
extern XtAppContext app_context;
extern SCORES scores[NUMSCORES];
extern SCORES old_scores[NUMSCORES];
extern SCORES cur;

extern int position;
extern enum gamestate game_state;
extern flag is_score_status;

void score_status_int_hlr();

int changed[NUMSCORES];		/* index table of new scores */
time_t last_time;		/* time last changed of hiscores file */
flag update_scorelist;
XtIntervalId score_status_clocker;

char header[100];


init_score_status_mgr()
{
	int pause = SCORE_STATUS_TIMEOUT;

	score_status_clocker=
		XtAppAddTimeOut(app_context, pause, score_status_int_hlr, 0);

}

init_header()
{
	sprintf(header,"%2s %-10s %9s %2s %s %-12s %s",
		"Nr", "USER", "SCORE","SP","W","HOST","DATE");
}



void score_status_int_hlr(w, id)
Widget w;
XtIntervalId *id;
{
	int pause = SCORE_STATUS_TIMEOUT;

	score_status_clocker=XtAppAddTimeOut(app_context, pause, score_status_int_hlr, 0);

	if((is_score_status) || (game_state == st_idle))
		draw_score_status(kUNFORCED);
}



draw_score_status(mode)
char mode;
{
	char string[100];
	char date_st[30];
	char user_st[30];
	struct passwd *pw;
	char f_changed;
	int i;

	f_changed = file_changed(SCOREFILE);

#ifdef DEBUG
	if(mode == kUNFORCED)
/*
		printf("interrupt! File is %s changed\n",
			f_changed ? "" : "NOT");
*/
		;
#endif

	if(f_changed) {
		copy_oldscores();
		read_scores();
		compare_scores();
	} 

	if(!f_changed && (mode == kUNFORCED))
		return 0;

	set_color(score_status_screen, BLUE, NO_COLOR);

	clear_window(score_status_screen);

	draw_string(score_status_screen,XPOS, YPOS(0)+9, header);
	draw_string(score_status_screen,XPOS+1, YPOS(0)+9, header);

	for(i = 0;  i < NUMSCORES; i++) {
		if(scores[i].score == 0)
			break;

		strcpy(date_st, ctime(&(scores[i].date)));
		date_st[strlen(date_st)-1] = '\0';
		pw = getpwuid(scores[i].user);
		if(pw)
			strcpy(user_st, pw->pw_name);
		else
			sprintf(user_st,"(uid=%d)",scores[i].user);

		compose_score_string(string, i,scores[i], user_st, date_st);

		if(changed[i])
			draw_newpic(3, YPOS(i+1) + 8);
		draw_string(score_status_screen,XPOS, YPOS(i+2), string);
		if(position == i) {
			set_color(score_status_screen, RED, NO_COLOR);
			draw_string(score_status_screen,XPOS+1,YPOS(i+2),string);
			draw_string(score_status_screen, XPOS, YPOS(i+2), string);
			set_color(score_status_screen, BLUE, NO_COLOR);
		} 
	}
}


toggle_score_status()
{
	is_score_status = !is_score_status;

	/* only switch state-windows if game is playing */
	if(game_state == st_playing) {
		if(is_score_status)
			show_score_status();
		else
			hide_score_status();
	}
	check_score_status_item(is_score_status);
}



copy_oldscores()
{
	int i;

	reset_changed();
	
	if(position < NUMSCORES) {
		memcpy((char*)&cur, (char*)&scores[position], sizeof(cur));
	}

	/* make a backup of the old scores */
	for(i = 0; i < NUMSCORES; i++)
		old_scores[i] = scores[i];
}


compare_scores()
{
	int i,j;

	position = NUMSCORES;

	/* now compare old scores with new scores */

	j = 0;
	for(i = 0; i < NUMSCORES; i++) {
		if(is_newscore(scores[i]))
			changed[i] = 1;
	}
	
	for(i = 0; i < NUMSCORES; i++) {
		if(!cmp_score(cur, scores[i])) {
			position = i;
			return;
		}
	}
}


is_newscore(s)
SCORES s;
{
	int i;

	for(i = 0; i < NUMSCORES; i++)
		if(!cmp_score(s, old_scores[i]))
			return 0;
	return 1;
}


reset_changed()
{
	int i;

	/* clear changed index */
	for(i = 0; i < NUMSCORES; i++)
		changed[i] = 0;
}


int cmp_score(s1, s2)
SCORES s1, s2;
{
	return memcmp((char*)&s1, (char*)&s2, sizeof(s1));
}

	

int file_changed(s)
char *s;
{
	struct stat info;
	int changed = 0;

	if(stat(s, &info)) {
		fprintf(stderr,"Warning: cannot stat '%s'\n", s);
		return changed;
	}
	if(info.st_mtime != last_time) {
		changed = 1;
		last_time = info.st_mtime;
	}

	return changed;
}

int compose_score_string(s,pos,score, user, date)
char *s;
int pos;
SCORES score;
char *user;
char *date;
{
	sprintf(s,"%2d %-10s %9ld %2d %c %-12s %s",
		pos+1, user, score.score, score.speed, score.wizard ? '*' : ' ',
		score.host, date);
}

show_scores_offline()
{
	int i;
	char date_st[30];
	char user_st[30];
	char string[100];
	struct passwd *pw;

	fprintf(stderr,"\nT H E   B E S T   T R O J K A   P L A Y E R S\n");
	fprintf(stderr,"\n%s\n", header);

	for(i = 0;  i < NUMSCORES; i++) {
		if(scores[i].score == 0)
			break;
		strcpy(date_st, ctime(&(scores[i].date)));
		date_st[strlen(date_st)-1] = '\0';
		pw = getpwuid(scores[i].user);
		if(pw)
			strcpy(user_st, pw->pw_name);
		else
			sprintf(user_st,"(uid=%d)",scores[i].user);

		compose_score_string(string,i,scores[i],user_st, date_st);
		fprintf(stderr,"%s\n", string);
	}

	putchar('\n');
}
