/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	do the drawing of objects on the screen
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xlib.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "xtrojka.h"
#include "screen.h"
#include "resource.h"
#include "bitmaps/new"
#include "bitmaps/title"

extern int field[VIRT_XSIZE][VIRT_YSIZE];

extern unsigned long score;
extern int speed;

extern flag is_color;
extern flag is_wizard;

extern void about_button_hlr();
extern void redraw_about_hlr();

Widget score_status_shell, about_shell;	
extern Widget screen;
extern Widget about_screen, score_status_screen;
extern Widget speed_box;	/* for "Score:" and score */
extern Widget score_box;	/* for "Speed:" and speed */

Pixmap blockPic[BLOCKS + 1];
Pixmap newPic;
Pixmap titlePic;

extern XFontStruct *font;
extern Pixel black_pix;
extern Pixel white_pix;

flag is_about;
flag is_auto_position;	/* autoposition the score status window? */
flag is_first_time;	/* true if the score st win is showed the first time */

char *about_string[100] =
{
	"X  T  R  O  J  K  A",
	" ",
	"Version 1.1",
	"Copyright (c) 1994, 1995",
	"Maarten Los",
	""
};

void makeblock(x,y,i)
int x,y,i;
/*
 *	draws a block on the screen
 */
{
	if(is_color) {
		XSetForeground(field_d, field_gc, app_data.color[i]);
		XSetBackground(field_d, field_gc, app_data.color[BLACK]);
		XFillRectangle(field_d, XtWindow(screen), field_gc,
			x * BLOCK_XSIZE + 2, (PLM_TOP-y) * BLOCK_YSIZE,
			BLOCK_XSIZE-1, BLOCK_YSIZE-1);
	} else {
		XCopyArea(field_d, blockPic[i], XtWindow(screen), field_gc,
			0,0, BLOCK_XSIZE, BLOCK_YSIZE,
			x * BLOCK_XSIZE + 2, (PLM_TOP - y) * BLOCK_YSIZE
		);
	}
}

void wipeblock(x,y)
int x,y;
/*
 *	wipes a block from the screen
 */
{
	makeblock(x,y, 0);
}


void show_score()
{
/*
 *	display the score 
 */
	char str_score[10];
	Dimension x,y;
	
	sprintf(str_score,"%ld", score);

	XtVaSetValues(score_box, 
		XtNlabel, str_score,
		NULL
	);
}

void show_speed()
{
/*
 *	Displays the speed
 */

	char str_speed[10];
	
	sprintf(str_speed,"%ld", (long)speed);
	XtVaSetValues(speed_box, 
		XtNlabel, str_speed,
		NULL
	);
}



draw_string(w, x,y,s)
Widget w;
int x,y;
char *s;
{
	XDrawString(XtDisplay(w),
		XtWindow(w),
		DefaultGCOfScreen(XtScreen(w)),
		x,y, s, strlen(s)
	);
}

draw_field()
{
	int x,y;

	clear_window(screen);

	for(y = PLM_TOP; y >= PLM_BOTTOM; y--) {
		for(x = 0; x < VIRT_XSIZE; x++)
			makeblock(x,y,field[x][y]);
	}
}

draw_newpic(x,y)
int x,y;
{

	if(is_color) {
		set_color(score_status_screen, MAGENTA, WHITE);
		XCopyPlane(XtDisplay(score_status_screen),
			newPic, XtWindow(score_status_screen),
			DefaultGCOfScreen(XtScreen(score_status_screen)),
			0,0, new_width, new_height, x,y, 1);
		set_color(score_status_screen, BLUE, NO_COLOR);
	} else {
		XCopyArea(XtDisplay(score_status_screen),
			newPic, XtWindow(score_status_screen),
			DefaultGCOfScreen(XtScreen(score_status_screen)),
			0,0, new_width, new_height, x,y);
	}
}

draw_title()
{
	int x,y;

	x = 3;
	y = 100;


	if(is_color) {
		set_color(screen, YELLOW, BLACK);
		clear_window(screen);
		XCopyPlane(XtDisplay(screen),
			titlePic, XtWindow(screen),
			DefaultGCOfScreen(XtScreen(screen)),
			0,0, title_width, title_height, x,y, 1);
	} else {
		clear_window(screen);
		XCopyArea(XtDisplay(screen),
			titlePic, XtWindow(screen),
			DefaultGCOfScreen(XtScreen(screen)),
			0,0, title_width, title_height, x,y);
	}
}


draw_about()
{
	int i;
	Dimension sw, sh;
	int tw, xloc, yloc;	

	if(is_about == 0)
		return;

	XtVaGetValues(about_screen, XtNwidth, &sw, XtNheight, &sh, NULL);

	/* count text lines */
	i = 0; while(about_string[i][0] != '\0') i++;
	yloc = (sh - (i*20)) / 2;

	clear_window(about_screen);

	if(is_color) {
		set_color(about_screen, GRAY, NO_COLOR);
		XFillRectangle(XtDisplay(about_screen), XtWindow(about_screen),
			DefaultGCOfScreen(XtScreen(about_screen)), 0,0, sw, sh);
		set_color(about_screen, YELLOW, NO_COLOR);
	}
	i = 0;
	while(about_string[i][0] != '\0') {
		tw = XTextWidth(font, about_string[i],strlen(about_string[i]));
		xloc = (sw - tw) / 2;
		draw_string(about_screen,xloc,yloc+(i+1)*20, about_string[i]);
		i++;
	}
}

toggle_auto_position()
{
	is_auto_position = !is_auto_position;
	check_auto_position_item(is_auto_position);
}

int scst_x,scst_y;	/* x and y of score status window */

show_score_status()
{
/*
 *	pops up the score_status window
 */

	if((is_auto_position) || (is_first_time)) {
		get_window_position(&scst_x, &scst_y);
		if(is_first_time)
			is_first_time = 0;
	}

	XtVaSetValues(score_status_shell,
		XtNx, (Dimension)scst_x,
		XtNy, (Dimension)scst_y,
		NULL
	);
	fix_dimensions(score_status_shell);
	XtPopup(score_status_shell, XtGrabNone);
}

show_about()
{
/*
 *	popup about box
 */
	int x,y;

	if(is_about)
		return;

	is_about = 1;

	

	XtAddEventHandler(about_screen, ButtonPressMask, False,
		about_button_hlr, (Opaque)NULL);
	XtAddEventHandler(about_screen, ExposureMask, False,
		redraw_about_hlr, (Opaque)NULL);


	XtPopup(about_shell, XtGrabNone);
}


hide_score_status()
{
/*
 *	pops down the score_status window
 */
	XtPopdown(score_status_shell);
}

set_color(w, fg, bg)
Widget w;
int fg, bg;
{
	if(is_color) {
		XSetForeground(XtDisplay(w),
			DefaultGCOfScreen(XtScreen(w)), app_data.color[fg]);
		if(bg < 0)
			return;
		XSetBackground(XtDisplay(w),
			DefaultGCOfScreen(XtScreen(w)), app_data.color[bg]);
	}

}
