/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	create the widgets
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
/*
#include <X11/Xlib.h>
*/

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "xtrojka.h"
#include "screen.h"
#include "resource.h"

#define S_WIDTH		520
#define S_HEIGHT	240
#define A_WIDTH		200
#define A_HEIGHT	150

extern Widget main_screen;
extern Widget trojkamenu_but, optionsmenu_but, speedmenu_but;

extern flag is_color;

Widget form, score_status_shell, about_shell;	
Widget leftpillar, rightpillar;	
Widget screen;
Widget about_screen, score_status_screen;
Widget speed_label, speed_box;	/* for "Score:" and score */
Widget score_label, score_box;	/* for "Speed:" and speed */

XFontStruct *font;
extern Pixmap app_icon;


clear_window(w)
Widget w;
{
	XClearWindow(XtDisplay(w), XtWindow(w));
}



void init_app_icon()
/*
 *	Set the applications icon
 */
{
	XtVaSetValues(main_screen,
		XtNiconPixmap, app_icon,
		NULL
	);

}


void init_windows()
/*
 *	initialize the whole widget stuff, INCLUDING the menu buttons.
 *	The rest of the menu-stuff is handled in menu_mgr.c.
 */
{
	form = XtVaCreateManagedWidget(
		"form",
		formWidgetClass,
		main_screen,
		NULL
	);

	trojkamenu_but = XtVaCreateManagedWidget(
		"trojkamenu_but",
		commandWidgetClass,
		form,
		XtNlabel,	"Trojka",
		NULL
	);


	optionsmenu_but = XtVaCreateManagedWidget(
		"controlmenu_but",
		commandWidgetClass,
		form,
		XtNlabel,	"Options",
		XtNfromHoriz,	trojkamenu_but,
		NULL
	);

	speedmenu_but = XtVaCreateManagedWidget(
		"speedmenu_but",
		commandWidgetClass,
		form,
		XtNlabel,	"Speed",
		XtNfromHoriz,	optionsmenu_but,
		NULL
	);

	score_label = XtVaCreateManagedWidget(
		"score_label",
		labelWidgetClass,
		form,
		XtNlabel,	"Score: ",
		XtNfromVert,	trojkamenu_but,
		XtNborderWidth,	0,
		NULL
	);

	score_box = XtVaCreateManagedWidget(
		"score_box",
		labelWidgetClass,
		form,
		XtNfromVert,	trojkamenu_but,
		XtNfromHoriz,	score_label,
		XtNlabel,	"         ",
		XtNborderWidth,	0,
		NULL
	);

	speed_label = XtVaCreateManagedWidget(
		"speed_label",
		labelWidgetClass,
		form,
		XtNlabel,	"Speed: ",
		XtNfromVert,	trojkamenu_but,
		XtNfromHoriz,	score_box,
		XtNborderWidth,	0,
		NULL
	);

	speed_box = XtVaCreateManagedWidget(
		"speed_box",
		labelWidgetClass,
		form,
		XtNlabel,	"       ",
		XtNfromVert,	trojkamenu_but,
		XtNfromHoriz,	speed_label,
		XtNborderWidth,	0,
		NULL
	);
	
	leftpillar =  XtVaCreateManagedWidget(
		"leftpillar",
		widgetClass,
		form,
		XtNwidth,	PILLAR_XSIZE,
		XtNheight,	WIN_YSIZE,
		XtNfromVert,	score_box,
		XtNborderWidth,	0,
		NULL
	);

	screen =  XtVaCreateManagedWidget(
		"screen",
		widgetClass,
		form,
		XtNwidth,	WIN_XSIZE,
		XtNheight,	WIN_YSIZE,
		XtNfromHoriz,	leftpillar,
		XtNfromVert,	score_box,
		NULL
	);

	if(is_color) {
		XtVaSetValues(screen,
			XtNforeground, app_data.color[WHITE],
			XtNbackground, app_data.color[BLACK],
			NULL
		);
	}

	rightpillar =  XtVaCreateManagedWidget(
		"rightpillar",
		widgetClass,
		form,
		XtNwidth,	PILLAR_XSIZE,
		XtNheight,	WIN_YSIZE,
		XtNfromHoriz,	screen,
		XtNfromVert,	score_box,
		XtNborderWidth,	0,
		NULL
	);
}
		
init_score_status_window()
{
/*
 *	initialize the whole score_status widget stuff
 */
	score_status_shell = XtVaCreatePopupShell(
		"Best Trojka Players",
		transientShellWidgetClass,
		main_screen,
		NULL
	);

	score_status_screen =  XtVaCreateManagedWidget(
		"score_status_screen",
		widgetClass,
		score_status_shell,
		XtNwidth,	S_WIDTH,
		XtNheight,	S_HEIGHT,
		NULL
	);
	
	font = XLoadQueryFont(XtDisplay(score_status_screen), SCORE_STATUS_FONT);
	XSetFont(	XtDisplay(score_status_screen),
			DefaultGCOfScreen(XtScreen(score_status_screen)),
			XLoadFont(XtDisplay(score_status_screen), SCORE_STATUS_FONT)
	);
}


init_about_window()
{
/*
 *	initialize the about box
 */
	about_shell = XtVaCreatePopupShell(
		"About Trojka",
/*
		transientShellWidgetClass,
*/
		overrideShellWidgetClass,
		main_screen,
		NULL
	);

	about_screen =  XtVaCreateManagedWidget(
		"about_screen",
		widgetClass,
		about_shell,
		XtNwidth,	A_WIDTH,
		XtNheight,	A_HEIGHT,
		NULL
	);
}


get_window_position(x,y)
int *x, *y;
{
	Dimension xdim, ydim;		/* dimensions of screen */
	Dimension txdim, tydim;	/* dimensions of trojka window */
	Dimension txloc, tyloc;	/* location of trojka window */
	

	xdim = WidthOfScreen(XtScreen(main_screen));
	ydim = HeightOfScreen(XtScreen(main_screen));

	XtVaGetValues(main_screen,
		XtNx, &txloc,
		XtNy, &tyloc,
		XtNwidth, &txdim,
		XtNheight, &tydim,
		NULL
	);
	
/*
fprintf(stderr,"main=%ldx%ld;trojka=%ldx%ld;trojka.location=%dx%d\n",	
	xdim,ydim,txdim,tydim,(int)txloc,(int)tyloc);
*/
	/*
	 *	see if there is room LEFT of main window
	 */
	if(txloc > (S_WIDTH + BORDER * 3)) {
		*x = txloc - (S_WIDTH + BORDER * 3);
		*y = tyloc - MBARHEIGHT;
		return 0;
	}


	/*
	 *	see if there is room on the RIGHT of the main window
	 */
	if(txloc < (xdim - (txdim + S_WIDTH))) {
		*x = txloc + txdim + BORDER;
		*y = tyloc - MBARHEIGHT;
		return 0;
	}

	/*
	 *	see if there is room ABOVE the main window
	 */
	if(tyloc > (S_HEIGHT + BORDER + MBARHEIGHT*2)) {
		*x = txloc - BORDER;
		*y = tyloc - (BORDER + S_HEIGHT + MBARHEIGHT*2);
		return 0;
	}

	/*
	 *	see if there is room UNDER the main window
	 */
	if(tyloc < (ydim - (S_HEIGHT + tydim))) {
		*x = txloc - BORDER;
		*y = tyloc + tydim + BORDER;
		return 0;
	}

	/*
	 * otherwise, put the window on the bottom right
	 */
	*x = xdim - (S_WIDTH + (BORDER * 3));
	*y = ydim - (S_HEIGHT + (BORDER * 3));
}

fix_dimensions(shell)
Widget shell;
{
	Dimension width, height;
	
	XtVaGetValues(shell,
		XtNwidth, &width,
		XtNheight, &height,
		NULL
	);
	
	XtVaSetValues(shell,
		XtNmaxWidth, width,
		XtNminWidth, width,
		XtNmaxHeight, height,
		XtNminHeight, height,
		NULL
	);
}


