/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	main
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "xtrojka.h"
#include "screen.h"
#include "hiscore.h"
#include "resource.h"

extern int position;

extern flag is_about;
extern unsigned long wizard_switch;
extern flag ignore_clock;
extern flag is_gaps;
extern flag is_auto_position;
extern flag is_first_time;

extern int cur_layout;

void Quit();
void Draw();

Widget main_screen;		/* the mother of all widgets */
Widget score_status_screen;
XtAppContext app_context;
XtAppContext score_status_context;

enum gamestate game_state;

static char *COPYRIGHT = "@(#) xtrojka 1.1 (c) 1994,1995 Maarten Los";

unsigned long
	score,
	blocks,
	wipes,
	speedbonus;	/* bonus multiplier depending on speed */


flag	is_wizard,
	is_color,
	is_score_status;

int	shape,		/* index of block */
	xpos,           /* virtual coordinates of the falling block */
	ypos,		/* conversion to on-screen coordinates takes */
	last_xpos,	/* place in 'makeblock()' */
	last_ypos,

	statx,
	x_min, x_max,
	stacklevel,		/* level of stack */
	blockwidth,	/* width of a block in characters */
	level,
	oldspeed,
	speed,		/* game speed */
	speed_switch,	/* number of fallen blocks the speed is increased */
	trojkas,
	Pause,		/* game speed in milliseconds */
	field[VIRT_XSIZE][VIRT_YSIZE],
	block_count[BLOCKS];

static String fallback_resources[] = {
	"*form*font: 7x13bold",
	NULL
};

static XtResource resources[] = {
	{ "color0", "Color0", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[0]), XtRString, (caddr_t)"black" },
	{ "color1", "Color1", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[1]), XtRString, (caddr_t)"magenta" },
	{ "color2", "Color2", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[2]), XtRString, (caddr_t)"yellow" },
	{ "color3", "Color3", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[3]), XtRString, (caddr_t)"green" },
	{ "color4", "Color4", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[4]), XtRString, (caddr_t)"cyan" },
	{ "color5", "Color5", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[5]), XtRString, (caddr_t)"blue" },
	{ "color6", "Color6", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[6]), XtRString, (caddr_t)"red" },
	{ "color7", "Color7", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[7]), XtRString, (caddr_t)"gray" },
	{ "color8", "Color8", XtRPixel, sizeof(Pixel),
	  XtOffsetOf(AppData, color[8]), XtRString, (caddr_t)"white" }
};

AppData app_data;

main(argc, argv)
int argc;
char **argv;
{
	is_wizard = 0;
	is_score_status  = 0;
	is_auto_position = 1;
	is_first_time = 1;
	position = NUMSCORES + 1;
	

	init_header();
	read_scores();

	scan_arguments(argc, argv);

	main_screen = XtVaAppInitialize(
		&app_context,	/* application context */
		"XTrojka",	/* application class */
		NULL,0,		/* commandlineoptionlist */
		&argc, argv,	/* command line arguments */
		fallback_resources,	/* fallback resources*/
		NULL);		/* terminate varargslist */

	is_color = DefaultDepthOfScreen(XtScreen(main_screen)) > 1;

	if(argc > 1)
		if(!strcmp(argv[1],"NOcolor"))
			is_color = 0;

	XtGetApplicationResources(main_screen, &app_data, resources,
		XtNumber(resources), NULL, 0);

	init_windows();
	init_prefs();
	init_menus();
	make_bitmaps();
	initialize();

	/* now make the windows for the widgets and map them */
	set_pillar_redraw_handler();
	XtRealizeWidget(main_screen);
	init_score_status_window();
	init_about_window();

	fix_dimensions(main_screen);

	init_score_status_mgr();
	init_actions();
	init_app_icon();
	mainloop(app_context);
}


int quit_appl()
{
	write_prefs();	
	exit(0);
}

int resetgame()
{
	int i;

	resetfield();

	for(i = 0; i < BLOCKS; i++)
		block_count[i] = 0;

	score = 0;
	show_score();
	blocks = 0;
	trojkas = 0;
	wipes = 0;
	position = NUMSCORES + 1;
	wizard_switch = ((rand() % 10) * 500) + 2000;
	is_gaps = 1;
	ignore_clock = 0;
	init_random_q();
	cur_layout = get_qrandom();
	set_speed(speed);
	resetblock();
}


int resetblock()
{
	ypos = PLM_TOP + 1;
	xpos = VIRT_MIDDLE;
	last_xpos = xpos;
	last_ypos = ypos;
	shape = (rand() % BLOCKS) +1;
}


int resetfield()
{
	int x,y;

	for(x = 0; x < VIRT_XSIZE; x++)		/* clear virt. field */
		for(y = 1; y < VIRT_YSIZE; y++)
			field[x][y] = CLEAR;
	for(x = 0;x < VIRT_XSIZE; x++)		/* fill bottom-line */
		field[x][0] = -1;
	stacklevel = 0;
}


int multscore(mult)
unsigned long mult;
{
	score += ((unsigned long)((mult * speedbonus + speed) / 3) + 1);
}


int check_speed()
{
	if (blocks > speed_switch)
		speedup();
}


speedup()
{
	if(speed < MAXSPEED) {
		speed++;
		set_speed(speed);
	}

}


set_speed(speed)
int speed;
{
	speedbonus = (unsigned long)(speed+1);
	Pause = 200 - (speed+1)*15;
	speed_switch = SPEED_SWITCH * (speed + 1);
	set_speed_item(speed);
	show_speed();
}


initialize()
{
	read_prefs();
	set_speed(speed);
	check_score_status_item(is_score_status);
	check_wizard_item(is_wizard);	
	check_auto_position_item(is_auto_position);

	init_score_status_mgr();

	is_about = 0;
}


scan_arguments(argc, argv)
int argc;
char **argv;
/*
 * see if the -s argument is given somewhere. If so, show the scores and
 * quit
 */
{
	int i;

	for(i = 1; i < argc; i++) {
		if(!strncmp(argv[i],"-h", 2))  {
			show_help();
			exit(0);
		} else
		if(!strncmp(argv[i],"-s",2)) {
			show_scores_offline();
			exit(0);
		}
/*		if(!strncmp(argv[i],"- */
	}
}


show_help()
{
	fprintf(stderr,"\nUsage: xtrojka [-s] [-h] [-display name]\n\n");
	fprintf(stderr,"-s\tDisplays the scorelist.\n");
	fprintf(stderr,"-h\tShows this help.\n");
	fprintf(stderr,"-display name\tStart xtrojka on other X-display.\n\n");
}	


