/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	main header file
 */


#ifndef _xtrojka_h_
#define _xtrojka_h_

typedef unsigned char flag;


/*
 *	virtual-field defines
 */

/*	layout of the virtual matrix
		 ______________
21  		|__|__|__|__|__|<-------- buffer space for scanning,
20 PLM_TOP	|__|__|__|__|__|<--.	           contents are always 0
19		|  |  |  |  |  |    \
18		|              |     \  actual PLaying Matrix, where the
..		:              :      > on-screen visible blocks are stored
 2		|__|__|__|__|__|     /
 1 PLM_BOTTOM	|__|__|__|__|__|<---'
 0		|__|__|__|__|__|<-------- buffer space for bottom,
		  0  1  2  3  4                    contents are always != 0
			^_ _ _ _ _ _  VIRT_MIDDLE

*/

#define VIRT_XSIZE	5   	/* dimensions of virtual field-array */
#define VIRT_YSIZE	22
#define VIRT_MIDDLE	2	/* middle of virtual field 	*/
#define PLM_TOP		20	/* constants for PLaying Matrix, */
#define PLM_BOTTOM    	1


#define CLEAR		0 	/* empty space for fieldarray */
#define TAGGED		-1	/* tagged field element, ready to be wiped */

/*
 *	general
 */

#define BLOCKS		5
#define MAXSPEED	9
#define MESGS		19	/* number of cookies */
#define MAX_MESG_TIME	10
#define MESG_SWITCH	10000
#define SPEED_SWITCH	100
#define TROJKA		3	/* ..it's the magic number (yes, it is) */


enum gamestate {
	st_playing = 0,
	st_idle
};
	

#define kFORCED		1
#define kUNFORCED	0

#endif _xtrojka_h_
