/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"


#include "configs.h"
#include "xvid4.h"

#include "main.h"

#define MOD_NAME PACKAGE

int read_config_file(xvid_transcode_module_t *mod, char *file, int read)
{
        int ret = 0;
	xvid_plugin_single_t *onepass = &mod->cfg_onepass;
	xvid_plugin_2pass2_t *pass2   = &mod->cfg_pass2;
	xvid_enc_create_t    *create  = &mod->cfg_create;
	xvid_enc_frame_t     *frame   = &mod->cfg_frame;

	struct config complete_config[] =
		{
			/* Section [features] */
			{"features", "Feature settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"quant_type", &mod->cfg_quant_method, CONF_TYPE_STRING, 0, 0, 0, NULL},
			{"motion", &mod->cfg_motion, CONF_TYPE_INT, CONF_RANGE, 0, 6, NULL},
			{"chromame", &mod->cfg_chromame, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"vhq", &mod->cfg_vhq, CONF_TYPE_INT, CONF_RANGE, 0, 4, NULL},
			{"max_bframes", &create->max_bframes, CONF_TYPE_INT, CONF_RANGE, 0, 20, NULL},
			{"bquant_ratio", &create->bquant_ratio, CONF_TYPE_INT, CONF_RANGE, 0, 200, NULL},
			{"bquant_offset", &create->bquant_offset, CONF_TYPE_INT, CONF_RANGE, 0, 200, NULL},
			{"bframe_threshold", &frame->bframe_threshold, CONF_TYPE_INT, CONF_RANGE, -255, 255, NULL},
			{"quarterpel", &mod->cfg_quarterpel, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"gmc", &mod->cfg_gmc, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"trellis", &mod->cfg_trellis, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"packed", &mod->cfg_packed, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"closed_gop", &mod->cfg_closed_gop, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"interlaced", &mod->cfg_interlaced, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"cartoon", &mod->cfg_cartoon, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"hqacpred", &mod->cfg_hqacpred, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"frame_drop_ratio", &create->frame_drop_ratio, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"stats", &mod->cfg_stats, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"greyscale", &mod->cfg_greyscale, CONF_TYPE_FLAG, 0, 0, 1, NULL},

			/* section [quantizer] */
			{"quantizer", "Quantizer settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"min_iquant", &create->min_quant[0], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_iquant", &create->max_quant[0], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"min_pquant", &create->min_quant[1], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_pquant", &create->max_quant[1], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"min_bquant", &create->min_quant[2], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_bquant", &create->max_quant[2], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"quant_intra_matrix", &mod->cfg_intra_matrix_file, CONF_TYPE_STRING, 0, 0, 100, NULL},
			{"quant_inter_matrix", &mod->cfg_inter_matrix_file, CONF_TYPE_STRING, 0, 0, 100, NULL},

			/* section [cbr] */
			{"cbr", "CBR settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"reaction_delay_factor", &onepass->reaction_delay_factor, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"averaging_period", &onepass->averaging_period, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"buffer", &onepass->buffer, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},

			/* section [cbr] */
			{"vbr", "VBR settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"keyframe_boost", &pass2->keyframe_boost, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"overflow_control_strength", &pass2->overflow_control_strength, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"curve_compression_high", &pass2->curve_compression_high, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"curve_compression_low", &pass2->curve_compression_low, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"max_overflow_improvement", &pass2->max_overflow_improvement, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"max_overflow_degradation", &pass2->max_overflow_degradation, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"kfreduction", &pass2->kfreduction, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"kfthreshold", &pass2->kfthreshold, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"container_frame_overhead", &pass2->container_frame_overhead, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},

			/* End of the config file */
			{NULL, 0, 0, 0, 0, 0, NULL}
		};

	/* Read the values */
	if (read) ret = module_read_config(NULL, MOD_NAME, file, complete_config);

	if (!read) ret = module_print_config_core((file)?file:"stderr", complete_config);

	/* Print the values */
	//if (ret) module_print_config("["MOD_NAME"] ", complete_config);

	return ret;
}

///////////
// Globals
///////////

// main window
GtkWidget *window1;

// Matrix window
GtkWidget *window2;
GtkWidget *matrix_edit_filsel_dlg;

// help window
GtkWidget *helpwin;

// dlgs
GtkWidget *quant_intra_matrix_dlg;
GtkWidget *quant_inter_matrix_dlg;
GtkWidget *load_settings_dlg;
GtkWidget *save_settings_dlg;


// xvid config struct
xvid_transcode_module_t xcfg;
xvid_transcode_module_t xcfg_sav;






int xvidcfg2window(void)
{
    int index=0;
    char buf[128], *s;
    GtkWidget *c;

    if (!strncmp(xcfg.cfg_quant_method,"h263",4)) index=0;
    if (!strncmp(xcfg.cfg_quant_method,"mpeg",4)) index=1;

    c = lookup_widget(GTK_WIDGET(window1), "quant_type");
    gtk_option_menu_set_history(GTK_OPTION_MENU(c),index);

    c = lookup_widget(GTK_WIDGET(window1), "motion");
    gtk_option_menu_set_history(GTK_OPTION_MENU(c),xcfg.cfg_motion);

    c = lookup_widget(GTK_WIDGET(window1), "chromame");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_chromame);

    c = lookup_widget(GTK_WIDGET(window1), "vhq");
    gtk_option_menu_set_history(GTK_OPTION_MENU(c),xcfg.cfg_vhq);

    c = lookup_widget(GTK_WIDGET(window1), "max_bframes");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_bframes);

    c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.bquant_ratio);

    c = lookup_widget(GTK_WIDGET(window1), "bquant_offset");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.bquant_offset);

    c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_frame.bframe_threshold);

    c = lookup_widget(GTK_WIDGET(window1), "frame_drop_ratio");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.frame_drop_ratio);

    c = lookup_widget(GTK_WIDGET(window1), "quarterpel");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_quarterpel);

    c = lookup_widget(GTK_WIDGET(window1), "gmc");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_gmc);

    c = lookup_widget(GTK_WIDGET(window1), "trellis");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_trellis);

    c = lookup_widget(GTK_WIDGET(window1), "packed");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_packed);

    c = lookup_widget(GTK_WIDGET(window1), "closed_gop");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_closed_gop);

    c = lookup_widget(GTK_WIDGET(window1), "interlaced");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_interlaced);

    c = lookup_widget(GTK_WIDGET(window1), "cartoon");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_cartoon);

    c = lookup_widget(GTK_WIDGET(window1), "hqacpred");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_hqacpred);

    c = lookup_widget(GTK_WIDGET(window1), "greyscale");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_greyscale);

    c = lookup_widget(GTK_WIDGET(window1), "stats");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_stats);

    c = lookup_widget(GTK_WIDGET(window1), "min_iquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[0]);

    c = lookup_widget(GTK_WIDGET(window1), "min_pquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[1]);

    c = lookup_widget(GTK_WIDGET(window1), "min_bquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[2]);

    c = lookup_widget(GTK_WIDGET(window1), "max_iquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[0]);

    c = lookup_widget(GTK_WIDGET(window1), "max_pquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[1]);

    c = lookup_widget(GTK_WIDGET(window1), "max_bquant");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[2]);

    ///  Do the matrix loading
    c = lookup_widget(GTK_WIDGET(window1), "quant_intra_matrix");
    s = xcfg.cfg_intra_matrix_file;
    gtk_entry_set_text(GTK_ENTRY(c), (s && *s)?s:"");

    c = lookup_widget(GTK_WIDGET(window1), "quant_inter_matrix");
    s = xcfg.cfg_inter_matrix_file;
    gtk_entry_set_text(GTK_ENTRY(c), (s && *s)?s:"");

    c = lookup_widget(GTK_WIDGET(window1), "reaction_delay_factor");
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.reaction_delay_factor);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "averaging_period");
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.averaging_period);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "buffer");
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.buffer);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "keyframe_boost");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.keyframe_boost);

    c = lookup_widget(GTK_WIDGET(window1), "curve_compression_low");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.curve_compression_low);

    c = lookup_widget(GTK_WIDGET(window1), "curve_compression_high");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.curve_compression_high);

    c = lookup_widget(GTK_WIDGET(window1), "bitrate_payback_delay");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.overflow_control_strength);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "max_overflow_improvement");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.max_overflow_improvement);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "max_overflow_degradation");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.max_overflow_degradation);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "kfreduction");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.kfreduction);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "kfthreshold");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.kfthreshold);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = lookup_widget(GTK_WIDGET(window1), "container_frame_overhead");
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.container_frame_overhead);
    gtk_entry_set_text(GTK_ENTRY(c), buf);


    return 0;
}

int window2xvidcfg(void)
{
    int index;
    const char *s;
    GtkWidget *c, *menu, *active;

    c = lookup_widget(GTK_WIDGET(window1), "quant_type");
    menu = GTK_OPTION_MENU(c)->menu;
    active = gtk_menu_get_active(GTK_MENU(menu));
    index = g_list_index(GTK_MENU_SHELL(menu)->children, active);
    switch(index) {
	case 0: xcfg.cfg_quant_method = "h263"; break;
	case 1: xcfg.cfg_quant_method = "mpeg"; break;
    }

    //printf ("motion (%d) vhq (%d) chromame (%d)\n", xcfg.cfg_motion, xcfg.cfg_vhq, xcfg.cfg_chromame);

    c = lookup_widget(GTK_WIDGET(window1), "packed");
    xcfg.cfg_packed = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "closed_gop");
    xcfg.cfg_closed_gop = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "interlaced");
    xcfg.cfg_interlaced = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "quarterpel");
    xcfg.cfg_quarterpel = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "gmc");
    xcfg.cfg_gmc = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "trellis");
    xcfg.cfg_trellis = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "cartoon");
    xcfg.cfg_cartoon = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "hqacpred");
    xcfg.cfg_hqacpred = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "greyscale");
    xcfg.cfg_greyscale = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "chromame");
    xcfg.cfg_chromame = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "vhq");
    menu = GTK_OPTION_MENU(c)->menu;
    active = gtk_menu_get_active(GTK_MENU(menu));
    xcfg.cfg_vhq = g_list_index(GTK_MENU_SHELL(menu)->children, active);

    c = lookup_widget(GTK_WIDGET(window1), "motion");
    menu = GTK_OPTION_MENU(c)->menu;
    active = gtk_menu_get_active(GTK_MENU(menu));
    xcfg.cfg_motion = g_list_index(GTK_MENU_SHELL(menu)->children, active);

    c = lookup_widget(GTK_WIDGET(window1), "stats");
    xcfg.cfg_stats = GTK_TOGGLE_BUTTON (c)->active;

    c = lookup_widget(GTK_WIDGET(window1), "max_bframes");
    xcfg.cfg_create.max_bframes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));
    //printf("%d\n", xcfg.cfg_create.max_bframes);

    c = lookup_widget(GTK_WIDGET(window1), "max_bframes");
    xcfg.cfg_create.max_bframes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio");
    xcfg.cfg_create.bquant_ratio = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "bquant_offset");
    xcfg.cfg_create.bquant_offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "frame_drop_ratio");
    xcfg.cfg_create.frame_drop_ratio = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold");
    xcfg.cfg_frame.bframe_threshold = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "min_iquant");
    xcfg.cfg_create.min_quant[0] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "max_iquant");
    xcfg.cfg_create.max_quant[0] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "min_pquant");
    xcfg.cfg_create.min_quant[1] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "max_pquant");
    xcfg.cfg_create.max_quant[1] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "min_bquant");
    xcfg.cfg_create.min_quant[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "max_bquant");
    xcfg.cfg_create.max_quant[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "reaction_delay_factor");
    xcfg.cfg_onepass.reaction_delay_factor = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "averaging_period");
    xcfg.cfg_onepass.averaging_period = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "buffer");
    xcfg.cfg_onepass.buffer = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "keyframe_boost");
    xcfg.cfg_pass2.keyframe_boost = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "curve_compression_high");
    xcfg.cfg_pass2.curve_compression_high = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "bitrate_payback_delay");
    xcfg.cfg_pass2.overflow_control_strength = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "curve_compression_low");
    xcfg.cfg_pass2.curve_compression_low = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = lookup_widget(GTK_WIDGET(window1), "max_overflow_improvement");
    xcfg.cfg_pass2.max_overflow_improvement = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "max_overflow_degradation");
    xcfg.cfg_pass2.max_overflow_degradation = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "kfreduction");
    xcfg.cfg_pass2.kfreduction = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "kfthreshold");
    xcfg.cfg_pass2.kfthreshold = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = lookup_widget(GTK_WIDGET(window1), "container_frame_overhead");
    xcfg.cfg_pass2.container_frame_overhead = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    // matrix; memleak!
    c = lookup_widget(GTK_WIDGET(window1), "quant_intra_matrix");
    s = gtk_entry_get_text(GTK_ENTRY(c));
    if (s && *s) {
	if (xcfg.cfg_intra_matrix_file) free(xcfg.cfg_intra_matrix_file);
	xcfg.cfg_intra_matrix_file = strdup(s);
    } else  {
	if (xcfg.cfg_intra_matrix_file) free(xcfg.cfg_intra_matrix_file);
	xcfg.cfg_intra_matrix_file = NULL;
    }

    c = lookup_widget(GTK_WIDGET(window1), "quant_inter_matrix");
    s = gtk_entry_get_text(GTK_ENTRY(c));
    if (s && *s) {
	if (xcfg.cfg_inter_matrix_file) free(xcfg.cfg_inter_matrix_file);
	xcfg.cfg_inter_matrix_file = strdup(s);
    } else  {
	if (xcfg.cfg_inter_matrix_file) free(xcfg.cfg_inter_matrix_file);
	xcfg.cfg_inter_matrix_file = NULL;
    }

    return 0;
}

int matrix2window(int *matrix)
{
    GtkWidget *c;
    char buf[128]; 
    char field[128];
    int i, j, x;

    x = 0;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = lookup_widget(GTK_WIDGET(window2), field);
	    sprintf(buf, "%d", matrix [x]);
	    gtk_entry_set_text(GTK_ENTRY(c), buf);
	    ++x;
	}
    }


    return 0;
}
int window2matrix(int *matrix)
{
    GtkWidget *c;

    char field[128];
    int i, j, x;

    x = 0;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = lookup_widget(GTK_WIDGET(window2), field);
	    matrix [x] = atoi (gtk_entry_get_text(GTK_ENTRY(c)));
	    ++x;
	}
    }

    return 0;
}


int read_matrix(int *matrix, const char *filename)
{
	int i;
	FILE *input;
	
	/* Open the matrix file */
	if((input = fopen(filename, "rb")) == NULL) {
		return(1);
	}

	/* Read the matrix */
	for(i=0; i<64; i++) {

		int value;

		/* If fscanf fails then get out of the loop */
		if(fscanf(input, "%d", &value) != 1) {
			fclose(input);
			return(2);
		}

		/* Clamp the value to safe range */
		value     = (value<  1)?1  :value;
		value     = (value>255)?255:value;
		matrix[i] = value;
	}

	/* Fills the rest with 1 */
	while(i<64) matrix[i++] = 1;

	/* We're done */
	fclose(input);

	return(0);
	
}

char *ifile;
char *ofile;

int main (int argc, char *argv[])
{

 int i=0;
  GtkWidget *c;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  for(i=1; i<argc; ++i) {
      if (   !strcmp("-h", argv[i]) ||
             !strcmp("--help", argv[i]) ||
             !strcmp("-?", argv[i]) ) {
	  fprintf(stderr, "xvid4conf [ outfile [ infile ] ]\n");
	  fprintf(stderr, "xvid4conf -v\n");
	  exit(0);
      }
  }

  switch (argc) {
    case 2:
      if (!strcmp("-v", argv[1])) {
        fprintf(stderr,"xvid4conf v%s\n",VERSION);
        exit(0);
      }
      ofile = argv[1];
      ifile = NULL;
      break;

    case 3:
      ofile = argv[1];
      ifile = argv[2];
      break;

    case 4:
      fprintf(stderr, "xvid4conf outfile infile\n");
      exit(1);
      break;

    case 1:
    default:
      ifile = ofile = NULL;
      break;
  }


  window1 = create_window1 ();

  // fixup .. set menu default
  c = lookup_widget(GTK_WIDGET(window1), "motion");
  gtk_option_menu_set_history(GTK_OPTION_MENU(c),6);

  if (ifile) {
    GtkEntry *t = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "load_file_name_text"));
    int ret = read_config_file(&xcfg, ifile, 1);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read config from '%s': %s", ifile, "Error");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
	xvidcfg2window();
	gtk_entry_set_text(t, ifile);
    }
  }

  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "save_file_name_text"));

    window2xvidcfg();

    ret = read_config_file(&xcfg, ofile, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", ofile);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
	gtk_entry_set_text(text, ofile);
    }
  }



  // default settings stored in window1
  window2xvidcfg();

  // save initial defaults
  memcpy(&xcfg_sav, &xcfg, sizeof(xcfg));

  gtk_widget_show (window1);

  //helpwin = create_help_window(); gtk_widget_show(helpwin);

  //window2 = create_matrix_edit_dlg(); gtk_widget_show (window2);


  gtk_main ();
  return 0;
}

