/*

	xwipower -Ȥ-
	Masafumi OE <masa@fumi.org>

*/
#define DEFAULT_TEXT "Default Text"

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/file.h> 

#include <net/if.h>
#ifdef __FreeBSD__
#include <net/if_var.h>
#include <net/ethernet.h>
#include <machine/if_wavelan_ieee.h>
#include <machine/apm_bios.h>
#else
#include <netinet/in.h>
#include <netinet/if_ether.h>
#ifdef __NetBSD__
#include <dev/pcmcia/if_wi_ieee.h>
#include <machine/apmvar.h>
#else
#include <dev/pcmcia/if_wavelan_ieee.h>
#endif
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <err.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Simple.h>

static XrmOptionDescRec options[] = {
{"-i", ".iface", XrmoptionSepArg,    "wi0"},
{"-a", ".antmode", XrmoptionNoArg, "True"},
{"-c", ".chamode", XrmoptionNoArg, "False"},
};

/*
	QUA -> ANT_LEVEL MAPPING
*/
#define	ANT_MAX_LEVEL 6
int	ant_level[ANT_MAX_LEVEL]= {0,5,10,20,30,40};
/*
	
  41-     Best!! 
  ------------------------
  31-40   Better 
  21-30	  Good.  
  11-20   Normal.
   5-10   Bad
   1-4    Worst.   
   -----------------------
   0      Out of field

*/
#define	True 	1

#define	ANT_REFLESH		4  /* sec */
#define	CHART_SCALE	4

#define	CHART_MODE		1
#define	ANTENNA_MODE	0
/*
	APM
		*/
#define APMDEV  "/dev/apm"
#define	BAT_MAXIMAM 	99
#define	BAT_LOW 		10 
#define	AC_ONLINE 		1
#define	AC_OFFLINE 		0

void	redisplay(Widget, char *, XEvent *);
void	get_value();
void	mem_alloc();
void	*sig();

Widget	toplevel;
Widget	base, strip_chart_obj;
char	*iface = NULL;


unsigned	long	MyColor(display, color)
Display *display;
char	*color;
{
	Colormap cmap;
	XColor	c0, c1;

	cmap = DefaultColormap(display, 0);
	XAllocNamedColor(display, cmap, color, &c1, &c0);

	return (c1.pixel);
}
	

int	get_qua(ifname)
char	*ifname;
{
	
	
	struct wi_req       wreq;
	struct ifreq        ifr;
	int         s;

	bzero((char *)&ifr, sizeof(ifr));

	wreq.wi_len = WI_MAX_DATALEN;
	wreq.wi_type = WI_RID_COMMS_QUALITY;

	strcpy(ifr.ifr_name, ifname);
	ifr.ifr_data = (caddr_t)&wreq;

	s = socket(AF_INET, SOCK_DGRAM, 0);

	if (s == -1) err(1, "socket");

	if (ioctl(s, SIOCGWAVELAN, &ifr) == -1){
		return	0;
		/*
		err(1, "SIOCGWAVELAN");
		*/
	}
	close(s);


	return wreq.wi_val[0] ;
}	

char *get_ssid(ifname)
char	*ifname;
{
	
	
	struct wi_req       wreq;
	struct ifreq        ifr;
	char				*ptr;
	int					s, i;

	bzero((char *)&ifr, sizeof(ifr));

	wreq.wi_len = WI_MAX_DATALEN;
	wreq.wi_type = WI_RID_CURRENT_SSID;

	strcpy(ifr.ifr_name, ifname);
	ifr.ifr_data = (caddr_t)&wreq;

	s = socket(AF_INET, SOCK_DGRAM, 0);

	if (s == -1) err(1, "socket");

	if (ioctl(s, SIOCGWAVELAN, &ifr) == -1)
		err(1, "SIOCGWAVELAN");

	close(s);
	
	if (wreq.wi_type == WI_RID_SERIALNO) {
		ptr = (char *)&wreq.wi_val;
		for (i = 0; i < (wreq.wi_len - 1) * 2; i++) {
			if (ptr[i] == '\0')
				ptr[i] = ' ';
		}
	} else {
		ptr = (char *)&wreq.wi_val[1];
		for (i = 0; i < wreq.wi_val[0]; i++) {
			if (ptr[i] == '\0')
				ptr[i] = ' ';
		}
	}
	ptr[i] = '\0';

	return ptr;
}	


int	get_apm_bat(aip)
#if defined(__FreeBSD__)
apm_info_t aip;
#else if defined(__NetBSD__)
struct apm_power_info aip;
#endif
{
	
	int	fd;

#if defined(__FreeBSD__)
	fd = open(APMDEV, O_RDWR);
#else if defined(__NetBSD__)
	fd = open(APMDEV, O_RDONLY);
#endif
	if (fd == -1) {
		fprintf(stderr,"can't open %s", APMDEV);
		return -1;
	}
#if defined(__FreeBSD__)
    if (ioctl(fd, APMIO_GETINFO, aip) == -1)
		return	-1;
#else if defined(__NetBSD__)
    if (ioctl(fd, APM_IOC_GETPOWER, aip) == -1)
		return	-1;
#endif
	
	close(fd);
	return	0;
}		

static void usage(app)
char            *app;
{
    fprintf(stderr, "usage:  %s -i iface [-gd]\n", app);
	fprintf(stderr, "\tQuality of 802.11b-DS radio wave viewer.\n", app);
    fprintf(stderr, "\t%s -i iface -c  Chart mode\n", app);
    fprintf(stderr, "\t%s -i iface -a  Antena mode\n\n", app);
    exit(1);
}

static char *
GetResource (XrmDatabase db, char *app_name, char *res_name,
             char *app_class, char *res_class, char *def)
{
    char name [BUFSIZ];
    char class [BUFSIZ];
    char *type;
    XrmValue val;
    char *string = def;

    sprintf (name, "%s.%s", app_name, res_name);
    sprintf (class, "%s.%s", app_class, res_class);

    if (XrmGetResource (db, name, class, &type, &val)) {
        string = (char *) malloc (val.size + 1);
        strncpy (string, val.addr, val.size);
        string [val.size] = '\0';
    }
    return (string);
}


main(argc, argv)
int argc;
char	**argv;
{
	Arg			args[10];
	char		buf[255];
	Cardinal	num_args;
	int			i, mode=0;	
	char		**argvbak=argv;


	mode = ANTENNA_MODE;

	/* GET OPTION */
    while((i = getopt(argc, argv, "cai:")) != -1){
        switch(i){
        case 'i':
            iface = optarg;
            break;
        case 'c':
            mode = CHART_MODE;
			break;
        case 'a':
            mode = ANTENNA_MODE;
			break;
        default:
		}
    }

	if (iface==NULL){
		usage(argv[0]);
		exit(1);
	}

	toplevel = XtInitialize(argv[0], "Xwipower", options, 3, &argc, argv);

	if(mode){
		num_args = 0;
	
		strip_chart_obj = 
			XtCreateManagedWidget("chart", stripChartWidgetClass, 
									toplevel, args, num_args);
		XtAddCallback(strip_chart_obj, XtNgetValue, get_value, 0);
	}else{
		base = XtCreateManagedWidget("antenna", 
			simpleWidgetClass, toplevel, NULL, 0);
		XtAddEventHandler(base, ExposureMask, FALSE, 
							(XtEventHandler)redisplay, NULL);
		signal(SIGALRM,  (void(*)())sig);
		alarm(ANT_REFLESH);	
	}	

	XtRealizeWidget(toplevel);
	XtMainLoop();

}

void get_value(w, mode, value)
Widget w;
int mode;
double *value;
{
	FILE	*fp;
	char	str[256];
	static	int	ival	= 0;
	char	cval[10];

	*value = get_qua(iface)/CHART_SCALE;

}

Widget  wbak;
char    *selectbak;
XEvent  *eventbak;

void *sig(hoge)
int		hoge;
{
	 redisplay(wbak, (char *)&selectbak, (XEvent *)&eventbak);
}



static char *kengai[] = {
" ",
" ",
" ",
"  .........   ... .    ",
"  . .   . .   . . .    ",
"  . ..... .  .. . .    ",
"  .  . .  .  .  . .    ",
"  . ..... . ..... ..   ",
"  .  . .  . .  .. ...  ",
"  .........   ..  . .. ",
"  .  .    .  ..   .    ",
"  .  .... .  .    .    ",
"  .........       .    ",
" ",""};


static char *antenn[] = {
"............",
" ..  ..  ..",
"  .. .. ..",
"   ......",
"    ....",
"     ..",
"     ..",
"     ..",
"     ..",
"     ..",
"     ..",
"     ..",
"     ..",
""};


void redisplay(w, select, event)
Widget	w;
char	*select;
XEvent	*event;
{
	int		i,r, power;
	static	GC	gc = NULL;
	XSetWindowAttributes	att;

	if(!gc){
		gc = DefaultGC(XtDisplay(w), DefaultScreen(XtDisplay(w)));
	}
	wbak = w;
	selectbak = select;
	eventbak = event;
	

	XSetForeground(XtDisplay(w), gc, MyColor(XtDisplay(w),"gray30"));	
	/*
		
	     |
	*/
	XClearWindow(XtDisplay(w), XtWindow(w));
	/*XChangeWindowAttributes(XtDisplay(w), XtWindow(w), */
	i = get_qua(iface);
	{

		for(power=0; power <= ANT_MAX_LEVEL ; power ++){
			if (i <= ant_level[power]) break;
		}
	}
	if(power==0){
#define	XOFF 10
#define	YOFF 0
		for(r=0 ;kengai[r][0]!=NULL; r++){
			for(i = 0 ; kengai[r][i]!=0 ; i++){
				if(kengai[r][i] != ' '){
					XDrawPoint(XtDisplay(w), XtWindow(w), gc, 
							YOFF+i,XOFF+r);
				}
			}
		}
	}else{

		for(r=0 ; antenn[r][0]!=NULL; r++){
			for(i = 0 ;  antenn[r][i]!=0 ; i++){
				if( antenn[r][i] != ' '){
					XDrawPoint(XtDisplay(w), XtWindow(w), gc, 
						YOFF+i,XOFF+r);
				}
			}
		}
		for( i = 1 ; i < power ; i++ ){
			XDrawLine(XtDisplay(w), XtWindow(w), gc, 9+(i-1)*3,22, 
											9+(i-1)*3, 19-(i-1)*2);
			XDrawLine(XtDisplay(w), XtWindow(w), gc, 10+(i-1)*3,22, 
											10+(i-1)*3, 19-(i-1)*2);
		}	
	}

#define	BAT_XOFF 1
#define	BAT_YOFF 1

	/*
		draw DENCHI
	*/
	{
#if defined(__FreeBSD__)
		struct 	apm_info info;
#else if defined(__NetBSD__)
        struct apm_power_info info;
#endif
		int		bat_life;
        int     ac_line;
		static	flip_flag = True;

		get_apm_bat(&info);
#if defined(__FreeBSD__)
		bat_life = info.ai_batt_life;
        ac_line = info.ai_acline;
#else if defined(__NetBSD__)
		bat_life = info.battery_life;
        ac_line = info.ac_state;
#endif

		flip_flag*=-1;
		if(bat_life >0 && bat_life <=100 ){

				for ( i = BAT_YOFF; i< 8 ; i++){
					XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF+bat_life/5*((flip_flag == True && ac_line == AC_ONLINE && bat_life < BAT_MAXIMAM)), i,
									BAT_XOFF+bat_life/5, i);
				}


			if(!(bat_life<=BAT_LOW && ac_line == AC_OFFLINE && flip_flag == True )){
				/* UE WAKU */
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF, BAT_YOFF,
									BAT_XOFF+10*2, BAT_YOFF);
				/* SHITA WAKU */
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF, 8,
									BAT_XOFF+10*2, 8);

				/*oshiri*/
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF,  BAT_YOFF,
									BAT_XOFF, 8);

				/* atama */
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF+10*2, BAT_YOFF,
									BAT_XOFF+10*2, BAT_YOFF+2);
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF+10*2, 6,
									BAT_XOFF+10*2, 8);
				XDrawLine(XtDisplay(w), XtWindow(w), gc, 
									BAT_XOFF+10*2+1, 
									BAT_YOFF+2, BAT_XOFF+10*2+1, 6);
			}
		}
	}	

	XFlush(XtDisplay(w));
	alarm(ANT_REFLESH);	
}
