//=======================================
// Base.H
//
// Base of all game objects, including world,
// players, nibbles, worms etc...
//
// ZNibbles
// Vincent Mallet 1997, 1998
//=======================================

// $Id: Base.H,v 1.5 1999/05/12 01:40:22 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_BASE__
#define __H_BASE__


#include <iostream.h>


// #define DEBUG

class World;

class Base {
public:
  int     id;
  World & world;

  int get_id() { return id; }

#ifdef DEBUG
  static int total;

  inline Base(World &wr) : id(global_id), world(wr) { global_id++; total++;}
  inline Base(World &wr, int my_id) : id(my_id), world(wr) { total++; }

  inline ~Base()
  {
    total--;
    cout << "  <" << id << "/" << global_id 
	 << " deleted><left=" << total << ">  " << endl;
  }
#else

  inline Base(World &wr) : id(global_id), world(wr) { global_id++; }
  inline Base(World &wr, int my_id) : id(my_id), world(wr) { }

#endif

  void display() {  cout << "ID: " << id << endl; }

private:
  static int global_id;
}; // class Base


#endif // __H_BASE__ 
