//==============================
// BaseInterface.H
// 
// Abstract class, describes basic features an 
// ZNibbles interface should have.
// 
// ZNibbles
// Vincent Mallet 1997, 1998
//==============================

// $Id: BaseInterface.H,v 1.8 1999/05/11 02:18:34 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_BASEINTERFACE__
#define __H_BASEINTERFACE__

#include <stdlib.h>

#include "Base.H"

class Player;
class World;

class BaseInterface : public Base {
public:
  inline BaseInterface(World& wr) : Base(wr) { }

  virtual void init(int argc, char *argv[]) = 0; // Initialize the interface
  virtual void run() { };                        // start the interface
  virtual void end() { };                        // stop
  

  // What player do we control ?
  virtual void set_own_player(Player& p) = 0;
  
  // notification : a player is joining
  virtual void add_player(Player& p) = 0;

  // ... a player is leaving
  virtual void kill_player(Player& p, int reason) = 0;

  virtual void display_message(Player& from, char *msg, int priv) = 0;
  virtual void display_system_message(char *msg, 
				      Player *p = 0, 
				      int color = 0) = 0;

  virtual ~BaseInterface() { }
  
}; // class BaseInterface


#endif // __H_BASEINTERFACE__
