//====================================
// Common.H
// 
// Common definitions for ZNibbles
// 
// ZNibbles
// Vincent Mallet 1997, 1998
//====================================

// $Id: Common.H,v 1.5 1999/05/12 01:41:49 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_COMMON__
#define __H_COMMON__


// znibbles protocol msg types
enum PacketType { 
  TRAME_ERROR        = -1, 
  VOID_TRAME         =  0, 
  JOIN_GAME          =  1, 
  WORLD_DESC         =  2, 
  PLAYER_DESC        =  3, 
  CHANGE_NOTIFY      =  4,
  CYCLE_NOTIFY       =  5, 
  CYCLE_ACK          =  6, 
  NEW_WORM           =  7, 
  NEW_NIBBLE         =  8, 
  NEW_LONGOBJ        =  9, 
  NEW_MOVABLE        = 10, 
  QUIT_GAME          = 11,    
  PLAYER_QUIT        = 12, 
  CHANGE_DIRECTION   = 13, 
  PLAYER_CHANGEDIR   = 14, 
  CHANGE_REQUEST     = 15, 
  PLAYER_ATTACHWORM  = 16, 
  TEXT_MESSAGE       = 17,  
  PAUSE_OWN          = 18, 
  UNPAUSE_OWN        = 19, 
  PAUSE_GAME         = 20,
  UNPAUSE_GAME       = 21, 
  PLAYER_CHANGEDIR_OTHER   = 22, 
  JOIN_GAME_OTHER    = 23,
  YOUR_OTHER_PLAYER  = 24,
  MAX_TRAMETYPE 
}; 


// (x,y) position. Renamed to "_Position" to avoid name conflict with X11
struct _Position {
  int x;
  int y;
};

// test two positions for equality
inline int operator==(const _Position& a, const _Position& b)
{
  return (a.x == b.x && a.y == b.y);
}

// test two positions for difference
inline int operator!=(const _Position& a, const _Position& b)
{
  return (a.x != b.x || a.y != b.y);
}

// direction type definition
enum _Direction { 
  D_UP      = -1, 
  D_DOWN    = 1, 
  D_STOPPED = 0, 
  D_LEFT    = -2, 
  D_RIGHT   = 2 
};

typedef int Direction;


// reasons a player has to quit game
enum _Quit_Reasons { 
  QR_IACHECK      = 0, 
  QR_STILLTHERE   = 1, 
  QR_UNKNOWN      = 2, 
  QR_DEAD         = 3, 
  QR_ASKEDFORIT   = 4, 
  QR_SIGINT       = 5, 
  QR_SIGTERM      = 6
};



// check if there's something to read on fd
int read_ready(int fd, int tmout = 0);


#endif // __H_COMMON__
