//========================================
// About.C
//
// The About Box (GTK+)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: About.C,v 1.2 1999/05/09 10:09:22 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>

#include "About.H"


About  * About::_mythis = NULL; // @@ okay. See Menu.C. This sucks.


void About::handle_events()
{
  _opened = FALSE;
}


void About::display_about() 
{
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox, *vbox;
  GtkWidget *label;
  GtkWidget *dialog_action_area1;
  GtkWidget *but_close;
  
  char *text;
//   GtkWidget *pixmap1;
//   GdkPixmap *pixmap;
//   GdkBitmap *mask;
//   GtkStyle *style;


  if (_opened) 
    return;
  
  _window = gtk_dialog_new ();
  gtk_object_set_data(GTK_OBJECT (_window), "aboutwin", _window);
  GTK_WINDOW(_window)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title(GTK_WINDOW (_window), "About gZNibbles");
  gtk_window_set_policy(GTK_WINDOW (_window), FALSE, FALSE, TRUE);
  gtk_window_position(GTK_WINDOW (_window), GTK_WIN_POS_CENTER);
  gtk_widget_realize(_window);
  
  dialog_vbox1 = GTK_DIALOG(_window)->vbox;
  gtk_widget_show(dialog_vbox1);
  
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(dialog_vbox1), hbox, TRUE, TRUE, 0);
  
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

//   style=gtk_widget_get_style(_window);
//   pixmap=gdk_pixmap_create_from_xpm_d(_window->window,&mask,
// 				      &style->bg[GTK_STATE_NORMAL], (gchar **) logo_xpm);
//   pixmap1=gtk_pixmap_new(pixmap,mask);
//   gdk_pixmap_unref (pixmap);
//   gtk_widget_show(pixmap1);
//   gtk_box_pack_start(GTK_BOX(hbox),pixmap1,TRUE,TRUE,0);
  
    text = "\n\n  ZNibbles version " VERSION "  \n \n"    \
      "  A classic multiplayer Nibbles game  \n \n"   \
      "  by Vincent Mallet (c) 1997-1999  \n \n" \
      "  http://www.stud.enst.fr/~vmallet/ZNibbles.html  \n \n" \
      "Report bugs to <vmallet@enst.fr>\n\n\n";
  
  label = gtk_label_new(text);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);


  text = "Keys during play:\n" \
    "=================\n" \
    " Left, Right,\n"     \
    " Up, Down       : move worm\n" \
    " p, u           : pause/unpause game\n" \
    " P, U           : pause/unpause worm\n" \
    " 1, 2 ... 9, 0  : send online message\n" \
    " Ctrl-Q         : quit game\n";
  
  label = gtk_label_new(text);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX (vbox), label, TRUE, TRUE, 0);
  
  dialog_action_area1 = GTK_DIALOG(_window)->action_area;
  gtk_widget_show(dialog_action_area1);

  but_close = gtk_button_new_with_label("Close");
  gtk_widget_show(but_close);
  gtk_box_pack_start(GTK_BOX(dialog_action_area1), but_close, TRUE, TRUE, 0);
  gtk_container_border_width(GTK_CONTAINER(but_close), 5);
  gtk_signal_connect_object(GTK_OBJECT(but_close),
			    "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(_window));

  gtk_signal_connect(GTK_OBJECT(_window), 
		     "delete_event", 
		     GTK_SIGNAL_FUNC(About::handle_delete_static), 
		     this);

  gtk_signal_connect(GTK_OBJECT(_window),
		     "destroy", 
		     GTK_SIGNAL_FUNC(About::handle_destroy_static), 
		     this);

  gtk_widget_show(_window);
  _opened = TRUE;
}
