//========================================
// About.H
//
// The About Box (GTK+)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: About.H,v 1.2 1999/05/09 10:09:14 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_ABOUT__
#define __H_ABOUT__

#include <gtk/gtk.h>

class GtkInterface;

class About {

public:
  
  About() : _opened(FALSE) { }

  void display_about();
    
  static void display_about_static() { 
    if (_mythis == NULL) {
      _mythis = new About();
    }
    
    _mythis->display_about(); 
  }


  void handle_events();
  
  static gint handle_delete_static(GtkWidget *widget, 
				   GdkEvent *event, 
				   About *about) {
    about->handle_events();
    
    return FALSE;
  }

  static void handle_destroy_static(GtkWidget *widget, About *about) {
    about->handle_events();
  }


  GtkWidget *get_widget() { return _window; }

  



protected:
  //  GtkInterface&   main_gif;


  GtkWidget     * _window;
  GtkWidget     * _list;

  int             _opened;

  static About  * _mythis; // @@ okay. See Menu.C. This sucks.


};

#endif // __H_ABOUT__







