//========================================
// GtkInterface.H
// 
// GTK+ client interface for ZNibbles
// 
// ZNibbles
// Vincent Mallet 1999
//========================================

// $Id: GtkInterface.H,v 1.7 1999/05/12 01:55:20 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_GTKINTERFACE__
#define __H_GTKINTERFACE__

#include "DLList.h"

#include "BaseInterface.H"

#include "Common.H"
#include "Player.H"
#include "Trame.H"

#include "InfoBar.H"
#include "NibblesArea.H"
#include "Menus.H"
#include "MessageArea.H"
#include "UserList.H"

#include "gtk/gtk.h"

class World;
class GtkPlayer;

class GtkInterface : public BaseInterface {
public:
  GtkInterface(World& wr);
  ~GtkInterface() { }

  //==== from BaseInterface =======

  void init(int argc, char *argv[]);
  void run();
  void end() { }
  
  void set_own_player(Player& p);
  
  void add_player(Player& p);
  void kill_player(Player& p, int reason);
  
  void display_message(Player& from, char *msg, int priv);
  void display_system_message(char *msg,  Player *p = 0, int color = 0);


  //===== methods specific to GtkInterface =======

  void pause_request(int pause_type);

  void display_version();             // display version number (long format)
  void display_version_short();       // display version number (short format)
  void display_help(char *name);      // display help
  void display_play_help();           // display key help


  void join_game();

  void init_messages(char *filename);
  void send_predefined_message(int num);

  void activate_other_player();


  //===== private methods and attributes =======
protected:
  Trame               t;
  Trame               tx;
  
  int                 _socket_client;
  int                 _errors;
  
  static int          _dead_server; // bon, en attendant de resoudre le pb
  static int          _hack_socket_client; // :-(((((

  char              * _own_name;

  char              * predefined_messages[10];
  
  GtkWidget         * main_window;
  GtkWidget         * _hbox2;

  Menus               menus;
  UserList            userlist;
  MessageArea         messagearea;
  NibblesArea         nibblesarea;
  InfoBar             infobar;

  int                 _debug;   // boolean: debug mode

  int                 _two_key; // boolean: two-key mode
  int                 _stdin_input; // boolean : check for data on stdin ?

  GtkPlayer *         _main_player; // @@ this may look like a hack
  GtkPlayer *         _other_player; // @@ this IS a hack :)
  
  DLList<GtkPlayer *> _players;

  void make(int argc, char **argv);

  void check_stdin();

  static void pipe_handler(int sig);
  static void stop_handler(int sig);

  // Lookup a GtkPlayer given a specified player
  GtkPlayer * lookup_gtk_player(Player& player);


  // action to take when a WORLD_DESC message is received
  void do_world_desc();

  // action to take when a YOUR_OTHER_PLAYER message is received
  void do_your_other_player();

  // action to take when a VOID_TRAME message is received
  void do_void_trame();

  // action to take when a CYCLE_NOTIFY message is received
  void do_cycle_notify();


  // react to a configure event
  static gint configure_event (GtkWidget *widget, 
			       GdkEventConfigure *event, 
			       GtkInterface *pthis);

  // react to an expose event
  static gint expose_event (GtkWidget *widget, 
			    GdkEventExpose *event, 
			    GtkInterface *pthis);

  // react to a destroy event (get a chance to disconnect
  // from server)
  static void destroy(GtkWidget *widget, gpointer data);

  // react to a keypress event 
  static gint key_cb(GtkWidget *widget, 
		     GdkEventKey *event, 
		     GtkInterface *pmythis);

  static void handle_server_input_static(void *pthis,
					 gint source,
					 GdkInputCondition cond);

  // Work Procedure - called when GTK is idle.
  static gint myWorkProc(GtkInterface *pmythis);

  void handle_server_input();


}; // class GtkInterface

#endif /* __H_GTKINTERFACE__ */
