//========================================
// GtkPlayer.C
//
// The GUI representation of a player (GTK+)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: GtkPlayer.C,v 1.3 1999/05/12 01:54:10 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <gtk/gtk.h>

#include "GtkPlayer.H"

#include "InfoBar.H"

#include "Player.H"
#include "Trame.H"


// from PlayerObserver
void GtkPlayer::score_changed(Player& player)
{
  if (_infobar != NULL) {
    _infobar->set_score(player.get_score());
  }
}

void GtkPlayer::best_length_changed(Player& player)
{ 
  if (_infobar != NULL) {
    _infobar->set_best(player.get_worm_length());
  }
}


void GtkPlayer::send_direction(Direction direction) // default direction=0
{
  if (direction)
    _dirs.append(direction);

  if (!_sent && _dirs.length()) {
    send_direction0(_dirs.front(), !direction);
    _dirs.remove_front();
    _sent = 1;
  }
}

void GtkPlayer::send_direction0(Direction direction, int do_append)
{
  if (!do_append)
    _tx->reset();
  if (is_master()) {
    _tx->put_char(PLAYER_CHANGEDIR);
  } 
  else {
    _tx->put_char(PLAYER_CHANGEDIR_OTHER);
    _tx->put_int(_player->get_worm_id());
  }    
  _tx->put_char(direction);
  if (!do_append)
    _tx->send_to(_socket_client);
}



#ifdef NONONON
void GtkPlayer::handle_server_input()
{

//DBG   cerr << nnn << " " ;
//DBG   nnn = 0;

//DBG   cerr<<"<";
  if (input_frame.receive_from(_socket_client)) {
    cerr << "GtkPlayer::handle_server_input(): read error" << endl;
    return;
  }
//DBG  cerr<<">";

  //       cerr << "X";
  
  switch(input_frame.peek_char()) {
  case TRAME_ERROR:
    break; // @@ we'll see that later
    
  case WORLD_DESC: 
    if (is_master())
      gtk_interface.read_world_desc(*_input_frame);
    _tx.reset();
    _tx.put_char(CYCLE_ACK);
    _tx.send_to(_socket_client);
    gtk_interface.update_world()
    world.draw();
    nibblesarea.draw_from_map(world.map);
    nibblesarea.redraw();
    break;
    
  case CHANGE_NOTIFY:
    input_frame.get_char(); 
    world.read_changes(input_frame);
    break;
    
  case VOID_TRAME:
    {
      if (_debug)
	cout << "got VOID_TRAME " << endl;
      input_frame.get_char();
      char *p = input_frame.get_string();
      if (p && strcmp(p, "w") == 0)
	world.display();
      else if (p && strcmp(p, "d") == 0) {
	world.draw();
	world.map.display();
      } else if (p && strcmp(p, "D") == 0) {
	world.build_maptype();
	world.map.display_t();
      }
    }
    break;
    
  case TEXT_MESSAGE:
    {
      input_frame.get_char(); // skip packet id
      int from_id = input_frame.get_int();
      char *msg = input_frame.get_string();
      display_message(world.lookup_player(from_id), msg, 1);
    }
    break;
    
    
  case CYCLE_NOTIFY:
    {
//       _sent = 0; 
      main_gtk_player.clear_sent();
      input_frame.get_char();
      world.cycle();
      world.read_changes(input_frame);
      mtx.reset();
      mtx.put_char(CYCLE_ACK);
      send_direction(); // if there's one in the queue..
      mtx.send_to(_socket_client);
      world.draw();
      nibblesarea.draw_from_map(world.map);
    }
    break;
    
  case QUIT_GAME:
    if (_debug)
      cout << "Got QUIT_GAME" << endl;
    cout << "Client shutting down.... " << endl;
    done = 1;
    break;
    
  default:
    if (_debug)
      cout << "got unknown frame type: " << (int) input_frame.peek_char() << endl;
    break;
  }

}

#endif

