//========================================
// GtkPlayer.H
//
// The GUI representation of a player (GTK+)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: GtkPlayer.H,v 1.3 1999/05/12 01:54:04 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_GTKPLAYER__
#define __H_GTKPLAYER__

#include <gtk/gtk.h>

#include "Common.H"
#include "Player.H"
#include "PlayerObserver.H"

#include "DLList.h"

class GtkInterface;
class InfoBar;
class Trame;

class GtkPlayer : public PlayerObserver {

public:

  GtkPlayer(GtkInterface& interface) : _gtk_interface(interface),
    _player(0), _window(0), _infobar(0), _input_frame(0), _tx(0), 
    _sent(0), _master(0), _debug(0)
  { }

  virtual ~GtkPlayer() { }

  void make();

  GtkWidget *get_widget() { return _window; }

  void set_player(Player * player) { _player = player; }
  Player * get_player() { return  _player; }

  void set_infobar(InfoBar * infobar) { _infobar = infobar; }
  InfoBar * get_infobar() { return _infobar; }

  void set_label(GtkWidget * label) { _label = label; }
  GtkWidget * get_label() { return _label; }

  void set_frame(Trame * frame) { _tx = frame; }
  Trame * get_frame() { return _tx; }

  void set_input_frame(Trame * frame) { _input_frame = frame; }
  Trame * get_input_frame() { return _input_frame; }
  
  void set_socket(int socket) { _socket_client = socket; }
  int get_socket() { return _socket_client; }

  void clear_sent() { _sent = FALSE; }
  int is_sent() { return _sent; }

  void set_master(int master) { _master = master; }
  int is_master() { return _master; }
  

  void activate_observation() { if (_player) _player->add_observer(this); }
  
  
  void send_direction(Direction direction = 0);


  // delegate to player
  char * get_name() { return _player->get_name(); }
  int    get_number() { return _player->get_number(); }


  // from PlayerObserver
  void score_changed(Player& player);
  void best_length_changed(Player& player);


protected:
  GtkInterface &  _gtk_interface;

  Player        * _player;

  GtkWidget     * _window;

  InfoBar       * _infobar;

  GtkWidget     * _label;

  Trame         * _input_frame;
  Trame         * _tx;
  
  DLList<Direction>   _dirs;

  int                 _socket_client;

  int                 _sent;

  int                 _master;

  int                 _debug;

  void send_direction0(Direction direction, int do_append);




};

#endif // __H_GTKPLAYER__







