//========================================
// InfoBar.C
//
// The GTK InfoBar. Displays information such
// as score, color, ...
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: InfoBar.C,v 1.3 1999/05/01 14:21:52 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>

#include <gtk/gtk.h>

#include "InfoBar.H"


// contruct all gui components of the bar
void InfoBar::make()
{
  GtkWidget *top_hbox;
  GtkWidget *hbox;
  GtkWidget *label;


  // main horizontal box container
  top_hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(top_hbox);

  _hbox  = top_hbox;

  // the score frame
  GtkWidget *frame = gtk_frame_new(NULL);
  //   gtk_widget_set_usize(frame, 200, 50);
  //   gtk_container_set_border_width(GTK_CONTAINER(frame), 3);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);

  gtk_container_add(GTK_CONTAINER(top_hbox), frame);

  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new (" Score: ");
  gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  label = gtk_label_new ("00000 ");
  gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  _score = label;

  gtk_container_add(GTK_CONTAINER(frame), hbox);

  gtk_widget_show (hbox);


  // the best length frame
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);

  gtk_container_add(GTK_CONTAINER(top_hbox), frame);

  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(" Best: ");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  label = gtk_label_new("00000 ");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  _best = label;

  gtk_container_add(GTK_CONTAINER(frame), hbox);

  gtk_widget_show (hbox);


  // the color frame
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);

  gtk_container_add(GTK_CONTAINER(top_hbox), frame);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_set_usize(hbox, 88, 10);
  label = gtk_label_new(" Color: ");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  _color_box = hbox;
  _gc = NULL;
  _pixmap = NULL;

  gtk_container_add(GTK_CONTAINER(frame), hbox);

  gtk_widget_show (hbox);
}


// set player's high score
void InfoBar::set_score(int score)
{
  char buf[10];
  
  sprintf(buf, "%5.5d ", score);
  
  gtk_label_set_text(GTK_LABEL(_score), buf);
}


// Set player's best length
void InfoBar::set_best(int best)
{
  char buf[10];

  sprintf(buf, "%5.5d ", best);

  gtk_label_set_text(GTK_LABEL(_best), buf);
}


// Display the new player's color
void InfoBar::set_color(GdkColor *color)
{
  if (_pixmap == NULL) {

    if (_gc == NULL)
      _gc = gdk_gc_new(_color_box->window);
    
    _pixmap = gdk_pixmap_new(_color_box->window, 45, 14, -1);

    GtkWidget * pixmapwid = gtk_pixmap_new(_pixmap, NULL);
    gtk_widget_show(pixmapwid);

    gtk_box_pack_start(GTK_BOX(_color_box), pixmapwid, FALSE, FALSE, 0);
  }

  gdk_gc_set_foreground(_gc, color);
  gdk_draw_rectangle(_pixmap, _gc, 1, 0, 0, 44, 13);
}
