//========================================
// InfoBar.H
//
// The GTK InfoBar. Displays information such
// as score, color, ...
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: InfoBar.H,v 1.2 1999/05/01 12:07:26 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_INFOBAR__
#define __H_INFOBAR__

#include <gtk/gtk.h>

class GtkInterface;

class InfoBar {

public :

  // constructor
  InfoBar(GtkInterface * gif) : _gif(gif) { }
  
  // contruct all gui components of the bar
  void make();

  // return top-level widget of this bar
  GtkWidget * get_widget() { return _hbox; }


  // set player's high score
  void set_score(int score);

  // Set player's best length
  void set_best(int best);

  // Display the new player's color
  void set_color(GdkColor *color);

private :

  GtkWidget *     _hbox;
  GtkWidget *     _score;
  GtkWidget *     _best;

  GtkWidget *     _color_box;

  GdkGC     *     _gc;
  GdkPixmap *     _pixmap;

  GtkInterface *  _gif;
};



#endif // __H_INFOBAR__

