//========================================
// menus.C
//
// The Menu Bar - GTK version
//
// ZNibbles
// Vincent Mallet 1997, 1998, 1999 - vmallet@enst.fr
//========================================

// $Id: Menus.C,v 1.5 1999/05/12 01:51:42 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// @@ Right now this is just a bunch of lines ripped from the
// @@ itemfactory.c GTK example and put together back into
// @@ a class.. I'll have to make real menus later.

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <gtk/gtk.h>

#include "Menus.H"
#include "About.H"

#include "GtkInterface.H"


enum { /* item numbers of File menu */
  ItemFileQuit  = 101,
  ItemFileOther = 102
};

enum { /* item numbers of Help menu */
  ItemHelpAbout = 111
};


GtkWidget * Menus::main_window;
GtkInterface * Menus::_interface;



// Obligatory basic callback 
void Menus::menu_callback_static(gpointer data, gpointer action, GtkWidget *w) {
  
  switch((gint) action) {
  case ItemFileOther:
    Menus::_interface->activate_other_player();
    gtk_widget_set_sensitive(w, FALSE);
    break;

  case ItemFileQuit:
    gtk_widget_destroy(Menus::main_window);
    break;
  }
}


GtkItemFactoryEntry Menus::menu_items[] = {
  {"/_File",         NULL,         NULL, 0, "<Branch>"},
  {"/File/_Add 2nd Player", "<control>A", (GtkItemFactoryCallback) menu_callback_static, ItemFileOther, NULL},
  {"/File/sep1",     NULL,         NULL, 0, "<Separator>"},
  {"/File/Quit",     "<control>Q", (GtkItemFactoryCallback) menu_callback_static, ItemFileQuit, NULL},
  {"/_Options",      NULL,         NULL, 0, "<Branch>"},
  {"/Options/Test",  NULL,         (GtkItemFactoryCallback) menu_callback_static, 55, NULL},
  {"/Options/Test2", NULL,         (GtkItemFactoryCallback) menu_callback_static, 0, NULL},
  {"/_Help",         NULL,         NULL, 0, "<Branch>"},
  {"/_Help/About",   NULL,         (GtkItemFactoryCallback) About::display_about_static, 0, NULL},
};



// Actually create this menu
void Menus::make(GtkWidget * main_w)
{
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
  GtkItemFactory *item_factory;
  GtkAccelGroup  *accel_group;

  accel_group = gtk_accel_group_new();

  main_window = main_w;


  /* This function initializes the item factory.
     Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
              or GTK_TYPE_OPTION_MENU.
     Param 2: The path of the menu.
     Param 3: A pointer to a gtk_accel_group.  The item factory sets up
              the accelerator table while generating menus.
  */

  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);

  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);

  /* Attach the new accelerator group to the window. */
  gtk_accel_group_attach (accel_group, GTK_OBJECT (main_window));


  /* Finally, return the actual menu bar created by the item factory. */ 
  menubar = gtk_item_factory_get_widget(item_factory, "<main>");

  gtk_object_set_user_data(GTK_OBJECT(menubar), this);

//   fprintf(stderr, "salope menubar: %08p\n", menubar);

  //  about = NULL; // no default about box. see set_about()
  


} // Menus::make()
 













