//========================================
// MessageArea.C
//
// The Message Area (GTK+) where messages are
// displayed
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: MessageArea.C,v 1.4 1999/05/09 10:09:32 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <gtk/gtk.h>

#include "MessageArea.H"

#include "GtkInterface.H"


// create all gui parts needed by the MessageArea
void MessageArea::make()
{
  GtkWidget *table;
  GtkWidget *text;
  GtkWidget *vscrollbar;
  
  // Create a table to hold the text widget and scrollbars 
  table = gtk_table_new (2, 2, FALSE);
  
  // Put a text widget in the upper left hand corner. Note the use of
  // GTK_SHRINK in the y direction 
  text = gtk_text_new (NULL, NULL);
  gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND | GTK_SHRINK) ,
		    (GtkAttachOptions)  (GTK_FILL  |  GTK_EXPAND), 0, 0);

  gtk_widget_set_usize(text, 20, 20);
  
  gtk_widget_show (text);
  
  /* And a VScrollbar in the upper right */
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		    (GtkAttachOptions) GTK_FILL, 
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK),
		    0, 0);
  gtk_widget_show (vscrollbar);

  //@@ word wrap missing !
  

  _text   = text;
  _window = table;
}


// Add a line in the window with the specified color
void MessageArea::add_line(char *line, GdkColor *color)
{
  GtkAdjustment *adj;
  int scroll = FALSE;

  adj = (GTK_TEXT(_text))->vadj;
  if (adj->value == adj->upper - adj->lower - adj->page_size) 
    scroll = TRUE;

  gtk_text_freeze (GTK_TEXT (_text));
  gtk_text_insert (GTK_TEXT (_text), NULL, color, NULL, line, -1);
  gtk_text_thaw (GTK_TEXT (_text));

  if (scroll)
    gtk_adjustment_set_value(adj, adj->upper - adj->lower - adj->page_size);
}


// Add multiple lines in the window with specified colors 
// (NULL terminated arrays)
void MessageArea::add_lines(char **lines, GdkColor **colors)
{
  GtkAdjustment *adj;
  int scroll = FALSE;

  adj = (GTK_TEXT(_text))->vadj;
  if (adj->value == adj->upper - adj->lower - adj->page_size) 
    scroll = TRUE;

  gtk_text_freeze (GTK_TEXT (_text));

  while (*lines != NULL) {
    gtk_text_insert (GTK_TEXT (_text), NULL, *colors, NULL, *lines, -1);
    gtk_text_thaw (GTK_TEXT (_text));
    
    lines++;
    colors++;
  }

  if (scroll)
    gtk_adjustment_set_value(adj, adj->upper - adj->lower - adj->page_size);
}

