//========================================
// MessageArea.H
//
// The Message Area (GTK+) where messages are
// displayed
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: MessageArea.H,v 1.2 1999/04/23 16:48:21 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_MESSAGEAREA__
#define __H_MESSAGEAREA__

#include <gtk/gtk.h>

// #include "GtkInterface.H"

class MessageArea {

public:
  void make();
  
  // Add a line in the window with the specified color
  void add_line(char *line, GdkColor *color);  

  // Add multiple lines in the window with specified colors 
  // (NULL terminated arrays)
  void add_lines(char **lines, GdkColor **colors);

  // Return the top level Gtk widget of this object
  GtkWidget *get_widget() { return _window; }

protected:
  GdkGC         * _gc;

  GtkWidget     * _window;
  GtkWidget     * _text;

};

#endif // __H_USERLIST__







