//========================================
// NibblesArea.H
//
// The object displaying the playable area of ZNibbles. 
// Big grid in which the worms move.
//
// ZNibbles
// Vincent Mallet 1997, 1998, 1999 - vmallet@enst.fr
//========================================

// $Id: NibblesArea.H,v 1.5 1999/05/11 02:23:53 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_NIBBLESAREA__
#define __H_NIBBLESAREA__

#include <gtk/gtk.h>

class GtkInterface;
class Map;

#define CELL_SIZE   11
#define CELL_SIZEM1 11


class NibblesArea {

public:
  GtkWidget * widget;

  NibblesArea(GtkInterface& mif);
  ~NibblesArea();

  void make();
  void make2(int x, int y);
  
  void set_config();

  void draw_at(int x, int y, int col);
  void draw_from_map(Map &map);
  void redraw(void);
  void clear();

  // Return the area size, in pixels.
  void get_size_pixel(gint *width, gint *height);
  
  GdkColor      * get_player_color(Player& p);



private:
  char       **   _map; 
  int             _x;
  int             _y;

  gint            _width;   // width of widget in pixel
  gint            _height;  // height of widget in pixel


  int             known_colors;
  GdkColor     ** colors;
  
  GtkInterface&   gif;

  GdkGC         * gc;
  GdkGC         * gc_background;

  GtkWidget     * draw;
  GdkWindow     * win;

  GdkColor      * head_color;
  GdkColor      * background_color;
  GdkColor      * default_color;
  GdkColor      * default_color2;
  GdkColor      * white_color;
  GdkColor      * yellow_color;
  GdkColor      * red_color;
  
  int             joined;

  GdkColor * get_new_color(gushort red, gushort green, gushort blue);

  inline void _draw_cell(int x, int y, int sx, int sy);
  
  static gint draw_exp_cb(GtkWidget *widget, 
			  GdkEventExpose *event, 
			  NibblesArea *mythis);
};


inline void NibblesArea::draw_at(int x, int y, int col)
{
  if (_map[y][x] != col) {
    _map[y][x] = col;
    _draw_cell(x, y, x * CELL_SIZE, y * CELL_SIZE);
  } 
}



#endif // __H_NIBBLESAREA__





