//========================================
// UserList.C
//
// The User List GUI (GTK+)
// (this is only the list widget. Players are
//  objects in the World)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: UserList.C,v 1.4 1999/05/11 02:23:38 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>

#include "UserList.H"

#include "GtkPlayer.H"

void UserList::make() 
{
  GtkWidget *scrolled_window;
  GtkWidget *list;
  
  // Create a new scrolled window, with scrollbars only if needed 
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);
  
  // Create a new list and put it in the scrolled window 
  list = gtk_list_new ();
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW (scrolled_window),
					list);
  gtk_widget_show (list);
  
  _list   = list;
  _window = scrolled_window;
}


// add an entry in the userlist GUI
void UserList::add_entry(GtkPlayer& gtk_player)
{
  GtkWidget *list_item;
  char s[200];

  Player& player = * gtk_player.get_player();

  sprintf(s, "#%2d  %-.25s", player.get_number(), player.get_name());

  list_item = gtk_list_item_new_with_label(s);
  
//   gtk_object_set_data(GTK_OBJECT(list_item), _this_key, &player);

  gtk_player.set_label(list_item);

  gtk_container_add (GTK_CONTAINER(_list), list_item);
  gtk_widget_show (list_item);
}


// remove an entry from the userlist GUI
void UserList::remove_entry(GtkPlayer& gtk_player)
{
  GList * list = NULL;

  list = g_list_prepend(list, gtk_player.get_label());

  gtk_list_remove_items(GTK_LIST(_list), list);
}
