//========================================
// UserList.H
//
// The User List GUI (GTK+)
// (this is only the list widget. Players are
//  objects in the World)
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: UserList.H,v 1.3 1999/05/11 02:22:44 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_USERLIST__
#define __H_USERLIST__

#include <gtk/gtk.h>

class GtkInterface;

class GtkPlayer;

class UserList {

public:
  UserList(GtkInterface& parent) : main_gif(parent), _this_key("this") { }
  
  void make();

  // add an entry in the userlist GUI
  void add_entry(GtkPlayer& player);

  // remove an entry from the userlist GUI
  void remove_entry(GtkPlayer& player);


  GtkWidget *get_widget() { return _window; }



protected:
  GtkInterface&   main_gif;
  
  char          * _this_key; // key used to get a widget "this" user_data 

  GtkWidget     * _window;
  GtkWidget     * _list;



};

#endif // __H_USERLIST__







