//========================================================
// LongObject.C
//
// Base class for dealing with long objects.
// Static long objects can be instances of LongObject
//
// ZNibbles
// Vincent Mallet 1997, 1998
//========================================================

// $Id: LongObject.C,v 1.5 1999/05/09 22:59:45 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#include "LongObject.H"

#include "Map.H"
#include "Trame.H"
#include "World.H"


// buggee! (quand collision...)
int LongObject::grow(Direction direction)
{
  int ret = update_pos(pos, direction);
  if (ret) 
    return ret;
  
  length++;
  queue.prepend(- direction);
  
  return 0;
}

void LongObject::draw(Map &map)
{
  _Position p = pos;
  
  if (dying)
    map.draw_point(p.x, p.y, 'X');
  else
    map.draw_point(p.x, p.y, '*');
  
  for (Pix q = queue.first(); q; queue.next(q)) {
    update_pos(p, queue(q));
    map.draw_point(p.x, p.y, '*');
  }
}


void LongObject::add_type(Map& map)
{
  _Position p = pos;
  
  _Object::add_type(map);

  for (Pix q = queue.first(); q; queue.next(q)) {
    update_pos(p, queue(q));
    map.add_type(p.x, p.y, *this);
  }  
}



int LongObject::update_pos(_Position &apos, Direction dir)
{
  switch(dir) {
  case D_UP:    
    if (apos.y > 0) { 
      apos.y--; 
      return 0; 
    } 
    return 1; 

  case D_DOWN: 
    if (apos.y < world.y_dim - 1) { 
      apos.y++; 
      return 0; 
    } 
    return 1; 
    
  case D_LEFT:  
    if (apos.x > 0) { 
      apos.x--; 
      return 0;
    } 
    return 1;

  case D_RIGHT: 
    if (apos.x < world.x_dim - 1) { 
      apos.x++; 
      return 0; 
    } 
    return 1; 
  }
  
  return -1;
}



void LongObject::add_description(Trame &t)
{
  t.put_char(NEW_LONGOBJ);

  add_description0(t);
}


void LongObject::read_description(Trame &t)
{
  if (t.get_char() != NEW_LONGOBJ) {
    cerr << "LongObject::read_description(): ohhh le bordel!\n";
    exit(1);
  }

  read_description0(t);
}

void LongObject::add_description0(Trame &t)
{
  _Object::add_description0(t);

  t.put_short(length);

  for (Pix p = queue.first(); p; queue.next(p)) 
    t.put_char(queue(p));
}

void LongObject::read_description0(Trame &t)
{
  _Object::read_description0(t);
  
  length = t.get_short();
  
  Direction d;
  for (int i = 0; i < length - 1; i++) {
    d = (Direction) t.get_char();
    queue.append(d);
  }
}


void LongObject::display()
{
  cout << "   ID:"<< id;
  printf(" %04x", classtype);
  cout << " LongObj " << pos.x << "x" \
       << pos.y << " len=" << length << " q=[ " ;

  Pix pix = queue.first();
  for (int i = length - 1; i > 0; i--) {
    cout << queue(pix) << " ";
    queue.next(pix);
  }
  cout << "]" <<  endl;
}


