//========================================================
// LongObject.C
//
// Base class for dealing with long objects.
// Static long objects can be instances of LongObject
//
// ZNibbles
// Vincent Mallet 1997, 1998, 1999
//========================================================

// $Id: LongObject.H,v 1.5 1999/05/09 22:59:41 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_LONGOBJECT__
#define __H_LONGOBJECT__

#include "DLList.h" // Doubly linked lists

#define CL_LONGOBJECT  0x00000080

#include "Object.H"

class Map;
class Trame;

class LongObject : public _Object {
public:
  int    length;  // longueur du machin, en incluant la tete
  
  DLList<Direction>  queue;  // liste de directions depuis la tete.
  
  LongObject(World &wr) : _Object(wr), length(1) { 
    classtype |= CL_LONGOBJECT; 
  }

  ~LongObject() { }

  virtual int  get_length() { return length; }

  int grow(Direction direction);
  
  void draw(Map& map);
  void add_type(Map& map);
  int update_pos(_Position& pos, Direction dir);
  
  void add_description(Trame& t);
  void read_description(Trame& t);
  
  void display();
  
protected:
  void add_description0(Trame& t);
  void read_description0(Trame& t);

}; // class

#endif // __H_LONGOBJECT__

