//====================================================
// Map.C
//
// The Nipples World Map (symbols and types)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//====================================================

// $Id: Map.C,v 1.5 1999/05/10 03:39:48 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif 

#include <stdio.h>
#include <iostream.h>
#include <string.h>

#include "Map.H"

// Actually constructs this Map.
void Map::make(int x, int y)
{
  _x = x;
  _y = y;
  
  _map = new char * [y];
  _maptype = new MapType ** [y];
  
  for (int i = 0; i < y; i++) {
    _map[i] = new char[x];
    _maptype[i] = new MapType * [x];
  }

  _maptype_line_size = sizeof(MapType *) * x;

  // _types is the actual storage space for maptypes
  _types_size  = (x * y) / 2;
  _types_index = 0;
  
  _types = (MapType *) malloc(_types_size * sizeof(MapType));

  // @@ do something appropriate here
  if (_types == NULL)
    cerr << "Map::make(): malloc failed. Everything should crash." << endl;

  clear();
}


// Destructor
Map::~Map()
{
  if (_map || _maptype) {
    for (int i = 0; i < _y; i++) {
      if (_map) delete[] _map[i];
      if (_maptype) delete[] _maptype[i];
    }
    if (_map) delete[] _map;
    if (_maptype) delete[] _maptype;
  }
  
  if (_types != NULL) {
    free(_types);
    _types = NULL;
  }
}


// Clear map and map_type 
void Map::clear(int c) // default c='.'
{
  for (int i = _y - 1; i >= 0; i--) {
    memset(_map[i], c, _x);    
    memset(_maptype[i], 0, _maptype_line_size);
  }

  _types_index = 0;
}


void Map::draw_number(int x, int y, int val)
{
  if (_map[y][x] == '.')
    _map[y][x] = val;
}

void Map::draw_point(int x, int y, int ch)
{
  _map[y][x] = ch;
}

// Text based display of this map (debug purposes)
void Map::display()
{
  cout << endl;
  
  for (int i = 0; i < _y; i++) {
    for (int j = 0; j < _x; j++)
      cout << _map[i][j] << " ";
    cout << endl;
  }
}

// Text based display of the types in the map (debug purposes)
void Map::display_t()
{
  cout << endl;
  
  for (int i = 0; i < _y; i++) {
    for (int j = 0; j < _x; j++) {
      cout << "? " ;
      //      cout << _maptype[i][j].length() << " ";
    }
    cout << endl;
  }
}

void Map::add_type(int x, int y, _Object& obj) 
{ 
  if (_types_index >= _types_size - 1) {
//     cout << "Map::add_type(): realloc()" << endl;
    // resize type array
    _types_size += 200;    // @@ computation has to be done correctly
    _types = (MapType *) realloc(_types, _types_size * sizeof(MapType)); 
    // @@ Do something in case of error !
    if (_types == NULL)
      cerr << "Map::add_type: realloc failed. Everything should crash." << endl;    
  }

  _types[_types_index].object = &obj;
  _types[_types_index].next   = NULL;

  if (_maptype[y][x] == NULL)
    _maptype[y][x] = _types + _types_index;
  else {
    MapType * mt = _maptype[y][x];
    while (mt->next != NULL)
      mt = mt->next;

    mt->next = _types + _types_index;
  }

  _types_index++;
}


// used for debug purposes only
void Map::print_type(int x, int y) 
{
  MapType * mt = get_type(x, y);

  if (mt == NULL) 
    cout << "<empty>";
  else {
    cout << "<" << mt->object;
    mt = mt->next;
    while (mt != NULL) {
      cout << "," << mt->object;
      mt = mt->next;
    }
    cout << ">";
  }
  
}
