//====================================================
// Map.H
//
// The Nipples World Map (symbols and types)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//====================================================

// $Id: Map.H,v 1.7 1999/05/10 03:39:38 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MAP_H__
#define __MAP_H__

#include <stdlib.h>

enum { MT_UNGETTABLE, MT_GETTABLE };

class _Object;
class NibblesArea;

typedef struct _MapType {
  _Object         * object;
  struct _MapType * next;
} MapType;


class Map {

  friend NibblesArea;

public:

  Map();
  ~Map();

  void make(int x, int y);

  void clear(int c = '.');
  void draw_number(int x, int y, int val);
  void draw_point(int x, int y, int ch);

  void add_type(int x, int y, _Object &obj);
  MapType * get_type(int x, int y) { return _maptype[y][x]; }
  int is_type_empty(int x, int y) { return _maptype[y][x] == NULL; }

  // for debug purposes
  void print_type(int x, int y);
  
  
  // for debug purposes
  void display();
  void display_t();
  
private:
  int         _x;       // size of map 
  int         _y;       // size of map 
  char    **  _map;     // visual map

  MapType *** _maptype; // map of types
  int         _maptype_line_size;

  MapType *   _types;   // actual storage for types
  int         _types_size;
  int         _types_index;
  

}; // class Map


inline Map::Map() : _x(0), _y(0), _map(0), _maptype(0), _types(0) { }



#endif // __MAP_H__
