//========================================
// MotifInterface.H
// 
// Motif client interface for ZNibbles
// (should make it X11 only)
// 
// ZNibbles
// Vincent Mallet 1997, 1998
//========================================

// $Id: MotifInterface.H,v 1.5 1999/05/10 03:31:59 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_MOTIFINTERFACE__
#define __H_MOTIFINTERFACE__

#include "BaseInterface.H"

#include "Common.H"
#include "Trame.H"

#include "DLList.h"

#include <Xm/Xm.h>
#include "UserList.H"
#include "horzpane.H"
#include "NibblesArea.H"
#include "menus.H"
#include "textarea.H"

class Player;
class World;

class MotifInterface : public BaseInterface {
public:
  MotifInterface(World& wr);

  void init(int argc, char *argv[]);
  void run();
  void end() { }
  
  void set_own_player(Player& p) { void *q = &p; q = q;}
  
  void add_player(Player& p);
  void kill_player(Player& p, int reason);
  
  void display_message(Player& from, char *msg, int priv);
  void display_system_message(char *msg,  Player *p = NULL, int color = 0);

  void send_direction(Direction direction = 0);
  
  void pause_request(int pause_type);

  void display_version();             // display version number (long format)
  void display_version_short();       // display version number (short format)
  void display_help(char *name);      // display help
  void display_play_help();           // display key help


  void join_game();

  void init_messages(char *filename);
  void send_predefined_message(int num);

protected:
  Trame             t;
  Trame             tx;
  
  int               socket_client;
  
  static int        dead_server; // bon, en attendant de resoudre le pb
  static int        hack_socket_client; // :-(((((

  int               sent;
  DLList<Direction> dirs;
  
  char            * own_name;

  char            * predefined_messages[10];
  
  Widget            toplevel;        // le bouton qui s'allume
  Widget            main_window;
  XtAppContext      context;
  Display         * display;

  int               not_configured;

  About             about;
  HorzPane          horzpane;
  Menus             menus;
  UserList          userlist;
  TextArea          textarea;
  NibblesArea       nibblesarea;

  int               debug;

  int               two_key; // boolean: two-key mode

  void make(int argc, char **argv);

  void configure(void);
  void reconfigure(void);

  void check_stdin();

  static Boolean myWorkProc(XtPointer closure);
  static void EventHandler(Widget w, XtPointer client_data, XEvent *event, char *z);
  static void pipe_handler(int sig);
  static void stop_handler(int sig);

  void send_direction0(Direction direction, int do_append);

}; // class MotifInterface


#endif // __H_MOTIFINTERFACE__
