//========================================
// about.C
//
// The About Box
//
// ZNibbles
// Vincent Mallet 1997, 1998 - vmallet@enst.fr
//========================================

// $Id: about.C,v 1.3 1999/04/14 15:01:10 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "motifutil.H"

#include "about.H"

// Actually creates this about box
void About::make(Widget _parent)
{
  parent = _parent;
  widget = NULL;
}

// Pop the about dialog box
void About::show_dialog(void)
{
  if (widget == NULL) {
    XmString  msg;

    msg = XmStringCreateLtoR("ZNibbles version " VERSION "\n \n"
			     "A Neat Little Game\n \n"
			     "(c) Vincent Mallet  1997, 1998, 1999\n \n"
			     "Keys during play:\n"
			     "=================\n"
			     " Left, Right,\n"
			     " Up, Down       : move worm\n"
			     " p, u           : pause/unpause game\n"
			     " P, U           : pause/unpause worm\n"
			     " Alt-X          : quit game\n \n"
			     "Report bugs to <vmallet@enst.fr>\n",
			     
			     XmSTRING_DEFAULT_CHARSET);

    widget = XmCreateMessageDialog(parent, "AboutDlg", NULL, 0);

    XtVaSetValues(widget, XmNmessageString, msg, 
		       XmNmessageAlignment, XmALIGNMENT_CENTER,
		       NULL, NULL);

    XtAddCallback(widget, XmNokCallback, about_handler, NULL);

    remove_button(widget, XmDIALOG_CANCEL_BUTTON);
    remove_button(widget, XmDIALOG_HELP_BUTTON);

    XmStringFree(msg);  
  }

  XtManageChild(widget);
  XtPopup(XtParent(widget), XtGrabNone);
}




// private stuff

void About::about_handler(Widget w, XtPointer client_data, XtPointer cbs) 
{
  w = w;                  // muffle warnings
  client_data = cbs;      // muffle warnings
}



