//========================================
// horzpane.C
//
// Home-made horizontal paned window.
//
// ZNibbles
// Vincent Mallet 1997, 1998 - vmallet@enst.fr
//========================================

// $Id: horzpane.C,v 1.3 1999/04/19 23:15:31 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/************** AAAAAATTTTTTEEEEEENNNNNTTTTTIIIIIOOOOOONNNNNN! ************************
****
****
****  Sous Linux, faut compiler avec  "-DLINUX" pour utiliser la bonne routine de 
****  creation du GC... sinon ca merdoie.
****
***************************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <Xm/Form.h>

#include "motifutil.H"
#include "horzpane.H"



void HorzPane:: make(Widget parent)
  // constructor
{
  widget    = XtVaCreateManagedWidget("formX", xmFormWidgetClass, parent, NULL);
  clicked   = 0;
  gc        = 0;

  XtAddEventHandler(widget, PointerMotionMask | ButtonPressMask | ButtonReleaseMask, False, EventHandler, (XtPointer) this);
}

void HorzPane:: set_objects(Widget left_widget, Widget right_widget)
  // set les deux objets qu'on va manager
{
  w1 = left_widget;
  w2 = right_widget;
}

void HorzPane:: nice_cursor(int shape)
  // houuu le joli cursor
{
  :: nice_cursor(widget, shape);
}




//////////////////////
//   Private Stuff  //
//////////////////////


void HorzPane:: EventHandler(Widget w, XtPointer client_data, XEvent *event, char *z)
  // Event Handler pour gerer la souris sur la form
{
  HorzPane * mythis = (HorzPane *) client_data;

  z = z;
  client_data = client_data;


  switch (event->type) {
  case MotionNotify:
    if (mythis->clicked) {
      mythis->toggle_line();
      mythis->oldx = ((XButtonEvent *)event)->x;
      mythis->toggle_line();
    }
    break;
  case ButtonPress:
    if (!mythis->clicked && ((XButtonEvent*)event)->button == Button1) {
      mythis->update_deltas();
      mythis->oldx    = ((XButtonEvent *)event)->x;
      mythis->toggle_line();
      mythis->clicked = 1;
    }
    break;
  case ButtonRelease:
    if (mythis->clicked) {
      mythis->toggle_line();
      mythis->clicked = 0;

      XtUnmanageChild(w);
      XtVaSetValues(mythis->w1, XtNwidth, mythis->oldx, NULL);
      XtVaSetValues(w, XmNwidth, 0, NULL);  // force un redraw
      XtManageChild(w);
    }
    break;
  default:
    //    printf("zHandler:: autre notify\n");
    break;
  }
}




#ifdef LINUX

void HorzPane:: get_GC(Display *display, GC *gc_out)
  // Cree le GC en Xor (version LINUX)
{
  XGCValues values;
  unsigned long valuemask;
  
  valuemask         = GCFunction | GCPlaneMask | GCForeground | GCBackground | GCLineWidth;
  
  values.function   = GXxor;
  values.line_width = 4;
  values.foreground = values.background = values.plane_mask =
    BlackPixel(display, DefaultScreen(display))  ^ WhitePixel(display, DefaultScreen(display));
  
  *gc_out = XCreateGC(display, RootWindow(display, DefaultScreen(display)), valuemask, &values);
}

#else

void HorzPane:: get_GC(Display *display, GC *gc_out)
  // Cree un GC en Xor (version solaris et autres)
{
  XGCValues values;
  unsigned long valuemask;

  valuemask         = GCFunction | GCForeground | GCBackground | GCLineWidth;

  values.function   = GXxor;
  values.line_width = 4;
  values.foreground = BlackPixel(display, DefaultScreen(display));
  values.background = WhitePixel(display, DefaultScreen(display));

  *gc_out = XCreateGC(display, RootWindow(display, DefaultScreen(display)), valuemask, &values);
}


#endif // LINUX

void HorzPane:: update_deltas()
  // calcule les positions relatives pour reussir
  // a afficher la ligne aux bonnes positions sur les
  // trois fenetres
{
  Position x, y, rx, ry;

  if (!gc)
    get_GC(XtDisplay(widget), &gc);

  XtVaGetValues(widget, XmNheight, &height, NULL);

  XtTranslateCoords(widget, 0, 0, &x, &y);
  XtTranslateCoords(w1, 0, 0, &rx, &ry);
  dx1 = x - rx;
  dy1 = y - ry;
  XtTranslateCoords(w2, 0, 0, &rx, &ry);
  dx2 = x - rx;
  dy2 = y - ry;
}

void HorzPane:: toggle_line()
  // Affiche la ligne en Xor sur les trois fenetres
  // celle de la forme, celles des deux objets
{
  XDrawLine(XtDisplay(widget), XtWindow(widget), gc, oldx, 0, oldx, height);
  XDrawLine(XtDisplay(w1), XtWindow(w1), gc, dx1 + oldx, dy1, dx1 + oldx, dy1 + height);
  XDrawLine(XtDisplay(w2), XtWindow(w2), gc, dx2 + oldx, dy2, dx2 + oldx, dy2 + height);
}


