//========================================
// horzpane.C
//
// Home-made horizontal paned window.
//
// ZNibbles
// Vincent Mallet 1997, 1998 - vmallet@enst.fr
//========================================

// $Id: horzpane.H,v 1.2 1998/11/17 08:40:15 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_HORZPANE__
#define __H_HORZPANE__

class HorzPane {
public:
  Widget widget;

  inline HorzPane() : widget(0) {}
  void make(Widget parent);

  void set_objects(Widget left_widget, Widget right_widget);
  void nice_cursor(int shape);

private:
  Widget    w1, w2;  // widgets of objects being managed

  GC        gc;
  int       dx1, dy1, dx2, dy2;
  Dimension height;
  int       oldx;
  int       clicked;

  void get_GC(Display *display, GC *gc);
  void update_deltas();
  void toggle_line();

  static void EventHandler(Widget w, XtPointer client_data, XEvent *event, char *z);

}; // class HorzPane


#endif // __H_HORZPANE__
