//========================================
// menus.C
//
// The Menu Bar
//
// ZNibbles
// Vincent Mallet 1997, 1998 - vmallet@enst.fr
//========================================

// $Id: menus.C,v 1.3 1999/04/14 14:50:14 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <Xm/CascadeB.h>

#include "menus.H"
#include "motifutil.H"


static Menus *mythis;  /* putain que c'est NUL bordel de C++ pourrave! :-(((( */


enum { /* item numbers of File menu */
  ItemFileQuit};

enum { /* item numbers of Help menu */
  ItemHelpAbout};


// called when an item of the file menu is selected
void Menus::file_handler(Widget w, XtPointer client_data, XtPointer cbs)
{
  w = w; cbs = cbs;

  switch( (int) client_data) {
  case ItemFileQuit:
    quit();
    break;
  }
}

// called when an item of the help menu is selected
void Menus::help_handler(Widget w, XtPointer client_data, XtPointer cbs)
{
  w = w; cbs = cbs;

  switch( (int) client_data) {
  case ItemHelpAbout:
    if (NULL != mythis->about)
      mythis->about->show_dialog();
    break;
  }
}




// Actually create this menu
void Menus::make(Widget main_w)
{
  Widget menu_bar, menu;
  Widget button;

  mythis = this;

  about = NULL; // no default about box. see set_about()
  
  main_window = main_w;

  menu_bar = XmVaCreateSimpleMenuBar(main_w, "MenuBar",
				     XmVaCASCADEBUTTON, NULL, 0, NULL);
  XtManageChild(menu_bar);

  menu = XmVaCreateSimplePulldownMenu(menu_bar, "FileMenu",
				      0, file_handler,
				      XmVaPUSHBUTTON,    NULL, 0, NULL, NULL,
				      NULL, NULL);
  
  menu = XmVaCreateSimplePulldownMenu(menu_bar, "HelpMenu",
				      3, help_handler,
				      XmVaPUSHBUTTON, NULL, 0, NULL, NULL,
				      NULL, NULL);

  button = XmCreateCascadeButton(menu_bar, "HelpButton", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, menu, NULL, NULL);
  XtManageChild(button);
  XtVaSetValues(menu_bar, XmNmenuHelpWidget, button, NULL);

  widget = menu_bar;
} // Menus::make()
 













