//========================================
// motifutil.H
//
// Some Motif goodies
//
// ZNibbles
// Vincent Mallet 1997, 1998 - vmallet@enst.fr
//========================================

// $Id: motifutil.C,v 1.4 1999/04/19 23:06:11 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/SashP.h>         // don't have a choice
#include <signal.h>

#include "motifutil.H"


void remove_button(Widget dialog, int button)
     /* Removes button number `btn' from dialog `dlg'. */
{
  Widget b;

  b = XmMessageBoxGetChild(dialog, button);
  XtUnmanageChild(b);
} // remove_button




void TurnOffSashTraversal(Widget panedw)
{
  Widget *children;
  int num_children;

  XtVaGetValues(panedw, XmNchildren, &children,
		        XmNnumChildren, &num_children,
		        NULL);

  while (num_children--)
    if (XmIsSash(children[num_children]))
      XtVaSetValues(children[num_children], XmNtraversalOn, False, NULL);
}


void nice_cursor(Widget widget, int shape)
{
  Cursor cursor;
  Display *dpy;
  Window  w;

  dpy = XtDisplay(widget);
  w   = XtWindow(widget);

  cursor = XCreateFontCursor(dpy, shape);
  XDefineCursor(dpy, w, cursor);
  XFreeCursor(dpy, cursor);
}




// static void quit_handler(Widget w, XtPointer client_data, XtPointer cbs)
// {
//   w = w; client_data = cbs;
// }


void quit(void)
{
  //  static Widget dialog;
  raise(SIGUSR1); // mieux :)
  exit(0); // ULTRA VIOLENCE!

//   //  if (vimmail.config.ask_before_quit) {
//     if (!dialog) {
//       //dialog = XmCreateWarningDialog(vimmail.interface.main_window, "QuitDialog", NULL, 0);
//       XtAddCallback(dialog, XmNokCallback, quit_handler, NULL);
//       remove_button(dialog, XmDIALOG_HELP_BUTTON);
//       XtManageChild(dialog);
//     }
//     else
//       XtManageChild(dialog);
//     //  }
//     //  else
//     //    ;
//     //    vimmail.end_app();
}


Widget GetTopShell(Widget w)
{
  while (w && !XtIsWMShell(w))
    w = XtParent(w);

  return w;
}



