//=============================================
// Movable.H
//
// Class for moving-objects (worms, etc.) 
//
// ZNibbles
// Vincent Mallet 1997, 1998
//=============================================

// $Id: Movable.H,v 1.4 1999/05/12 01:40:45 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_MOVABLE__
#define __H_MOVABLE__

#define CL_MOVABLE  0x00000100


#include "LongObject.H"

class Map;
class Trame;
class Player;
class Nibble;

class Movable : public LongObject {
public:

  int       speed;
  Direction direction;
  int       full_length;

  int       player_id; 
  Player  * player;     // redundant, but faster :)

  int       paused;
  int       baby;
  int       chacal;
  int       cut;
  int       two_keys;   // boolean: we can move worm with only two keys: 
                        // left and right

  // Constructor
  Movable(World &wr, int id_play = 0) : 
    LongObject(wr), speed(1), direction(D_DOWN), full_length(3), 
    player_id(id_play), player(NULL), paused(0), baby(4), chacal(0), 
    cut(0), two_keys(0)
  { classtype |= CL_MOVABLE; }
  

  Player * get_player() { return player; }
  

  void self_die();

  void add_description(Trame& t);
  void read_description(Trame& t);
  
  int auto_dir();
  int move(Direction dir);
  Direction two_key_translate(Direction input);

  void cycle();
  void server_cycle();

  void check_collide();
  void eat(Nibble& nib);
  void getcut(_Position cutpos);

  void display();
  void draw(Map& map);

protected:  
  void add_description0(Trame& t);
  void read_description0(Trame& t);

}; // class Movable

#endif // __H_MOVABLE__
