//======================================================
// Nibble.C
//
// The Nibble Object (including special bonus & power)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//======================================================

// $Id: Nibble.C,v 1.2 1998/11/17 08:36:32 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>

#include "Nibble.H"

#include "Map.H"
#include "Trame.H"
#include "World.H"


void Nibble::draw(Map &map)
{
  if (type == NT_STANDARD)
    map.draw_number(pos.x, pos.y,  value);
  else
    if (world.playcycle & 1)
      map.draw_number(pos.x, pos.y,  'S');
    else
      map.draw_number(pos.x, pos.y,  0);
}

void Nibble:: add_description(Trame &t)
{
  t.put_char(NEW_NIBBLE);

  add_description0(t);
}

void Nibble:: read_description(Trame &t)
{
  if (t.get_char() != NEW_NIBBLE) {
    cerr << "Nibble::read_description(): ohhh le bordel!\n";
    exit(1);
  }
  
  read_description0(t);
}

void Nibble::add_description0(Trame &t)
{
  _Object::add_description0(t);
  t.put_char(type);
  t.put_char(value);
}

void Nibble::read_description0(Trame &t)
{
  _Object::read_description0(t);
  type   = t.get_char();
  value  = t.get_char();
}

void Nibble::display()
{
  cout << "   ID:"<< id;
  printf(" %04x", classtype);
  cout << " Nibble  " << pos.x << "x" << pos.y << " value=" << value 
       << " type=" << type << endl;
}



