//======================================================
// Nibble.H
//
// The Nibble Object (including special bonus & power)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//======================================================

// $Id: Nibble.H,v 1.4 1999/05/09 22:59:17 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_NIBBLE__
#define __H_NIBBLE__

#include "Object.H"

#define CL_NIBBLE 0x00000040

class Map;
class Trame;

enum _Nibble_Type {
  NT_STANDARD, 
  NT_CHACAL, 
  NT_CUT, 
  NT_REVERSE, 
  NT_INVISIBLE, 
  NT_SLOW, 
  NT_ELECTRIC,

  NT_MAXSPECIAL
};

class Nibble : public _Object {
public:
  int  type;
  int  value;

  Nibble(World &wr, int _type, int val = 0) : 
    _Object(wr), type(_type), value(val) { classtype |= CL_NIBBLE; }

  void add_description(Trame &t);
  void read_description(Trame &t);

  void draw(Map &);
  void display();

protected:
  void add_description0(Trame &t);
  void read_description0(Trame &t);

}; // class Nibble;

#endif // __H_NIBBLE__
