//======================================================
// Object.C
//
// Base class for all world objects (nibbles, worms etc)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//=======================================================

// $Id: Object.C,v 1.4 1999/05/10 03:41:22 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <iostream.h>

#include "Object.H"
#include "World.H"


// Constructor
_Object::_Object(World &wr) : Base(wr), dying(0), classtype(CL_OBJECT)
{
  pos.x = 0;
  pos.y = 0;
}


// Default collision check: do nothing
void _Object::check_collide()
{
}

void _Object::server_cycle()
{
  cycle();
}

// Default cycle func: do nothing
void _Object::cycle()
{
}

void _Object::add_type(Map& map)
{
  map.add_type(pos.x, pos.y, *this);
}

// kind of serialization mechanism
void _Object::add_description0(Trame &t)
{
  t.put_int(id);
  t.put_int(classtype);
  t.put_short(pos.x);
  t.put_short(pos.y);
  t.put_char(dying);
}

// deserialization
void _Object::read_description0(Trame &t)
{
  id        = t.get_int();
  classtype = t.get_int();
  pos.x     = t.get_short();
  pos.y     = t.get_short();
  dying     = t.get_char();
}

void _Object::auto_position(Map& map)
{
  int maxtry = 20;
  //  int yes = 0;

  do {
    //    if (yes)
    //      cout << "Object::auto_position(): collide #" << yes << endl;
    //    yes++;
    pos.x = rand() % world.x_dim;
    pos.y = rand() % world.y_dim;
  } while (!map.is_type_empty(pos.x, pos.y) && maxtry--);
}
