//======================================================
// Object.H
//
// Base class for all world objects (nibbles, worms etc)
//
// ZNibbles
// Vincent Mallet 1997, 1998
//=======================================================

// $Id: Object.H,v 1.4 1999/05/09 22:59:06 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_OBJECT__
#define __H_OBJECT__

#include "Base.H"
#include "Common.H"

#define CL_OBJECT   0x00000020

class Trame;
class Map;

class _Object : public Base {
public:  

  _Position pos;
  int      color;
  
  int      dying;

  int      classtype;  // bit mapped for inheritance;

  _Object(World &wr);

  void auto_position(Map& map);
  
  // kind of serialization mechanism
  virtual void add_description(Trame& t) = 0;  
  // deserialization 
  virtual void read_description(Trame& t) = 0; 

  virtual void draw(Map& map) = 0;
  virtual void add_type(Map& map);

  virtual void display() = 0;

  virtual void server_cycle();
  virtual void cycle();

  virtual void check_collide();

  int instance_of(int whichclass); // hehehehe

  virtual ~_Object() { }

protected:
  void add_description0(Trame& t);
  void read_description0(Trame& t);

}; // class _Object


inline int _Object::instance_of(int whichclass) 
{ 
  return (classtype & whichclass); 
}



#endif // __H_OBJECT__
