//========================================
// Options.H
//
// Options Manager. Hum. Something to parse
// command line and later to parse a config
// file, if there ever is one.
//
// ZNibbles
// Vincent Mallet 1999 - vmallet@enst.fr
//========================================

// $Id: Options.H,v 1.4 1999/05/11 02:19:10 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_OPTIONS__
#define __H_OPTIONS__

#include "getopt.h"

#define OPTIONS_SERVER_SET   0
#define OPTIONS_CLIENT_SET   1

class Options {

public :

  Options();

  void   set_option_set(int set);
  
  // parse command line parameters
  //   return true if ok
  //   return false if wrong parameters
  bool   parse(int argc, char **argv);

  int    get_nonoption_index() { return optind; }

  // set values (default values if called before parse)
  void   set_player_name(char *playername) { _playername = playername; }
  void   set_host_name(char *hostname) { _hostname = hostname; }
  void   set_message_file(char *message_file) { _message_file = message_file; }
  void   set_debug(bool debug) { _debug = debug; }
  void   set_twoley(bool twokey) { _twokey = twokey; }

  void   set_width(int width) { _width = width; }
  void   set_height(int height) { _width = height; }
  
  void   set_no_computer(bool no_computer) { _no_computer = no_computer; }
  void   set_stdin_input(bool stdin_input) { _stdin_input = stdin_input; }

  // retrieve parameters value
  char * get_player_name() { return _playername; }
  char * get_host_name() { return _hostname; }
  char * get_message_file() { return _message_file; }
  int    get_port() { return _port; }
  bool   is_debug() { return _debug; }
  bool   is_twokey() { return _twokey; }
  bool   is_version() { return _version; }
  bool   is_help() { return _help; }

  int    get_width() { return _width; }
  int    get_height() { return _height; }

  bool   is_no_computer() { return _no_computer; }
  bool   is_stdin_input() { return _stdin_input; }
  
  
private:
  char          **  _options_sets;
  struct option **  _long_options_sets;

  int              _set;
  
  // options
  bool             _help;
  bool             _version;
  bool             _debug;
  bool             _twokey;
  bool             _stdin_input;
  int              _port;
  char           * _hostname;
  char           * _playername;
  char           * _message_file;

  int              _width;
  int              _height;

  bool             _no_computer;

};



#endif // __H_OPTIONS__

