//==============================
// Player.H
// 
// Represents a player, its score, ...
// 
// ZNibbles
// Vincent Mallet 1997, 1998
//==============================

// $Id: Player.H,v 1.6 1999/05/12 01:43:43 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_PLAYER__
#define __H_PLAYER__

#include <time.h>
#include <stdlib.h>
#include <unistd.h>

#include "DLList.h"

#include "Base.H"

class Trame;
class PlayerObserver;

class Player : public Base {
public:
  int    socket_number;   // socket number 
 
  int    worm_id;         // worm of player, 0 if player dead

  int    dead_cycle;      // number of cycles before creating a new worm

  long   playtime;        // time player has been playing for (useless? yes!)
  time_t starttime;       // time player started to play

  int    is_alive;        // used for player lifecheck

  int    two_key;         // boolean: two-key mode
  
  // Constructor ('inline' is here just for emacs' fontifier)
  inline Player(World & wr, int sock = 0) :
    Base(wr), socket_number(sock),
    worm_id(0), dead_cycle(0), playtime(0), 
    starttime(time(NULL)), two_key(0), _name(NULL), _score(0), _frag(0), 
    _best_length(0), _depend(0)
  { }

  // Destructor
  inline ~Player() 
  { 
    if (_name) free(_name); 
    if (socket_number)
      close(socket_number);
  }

  // debug: print a brief representation of the player
  void display();

  // get/set player name
  char *get_name() { return _name; }
  void set_name(char *s);
  
  // get/set player number
  void set_number(int number) { _number = number; }
  int  get_number() { return _number; }

  void set_twokey(int _two_key) { this->two_key = _two_key; }

  void add_description(Trame& t);   // add player description to frame t
  void read_description(Trame& t);  // update player data from frame t

  void add_score(int delta);       // update player score
  int  get_score() { return _score; }

  int  get_worm_id() { return worm_id; }
  int  get_worm_length();

  int  get_frag() { return _frag; }
  int  get_best_length() { return _best_length; }

  void set_dependent(int depend) { _depend = depend; }
  int  is_dependent() { return _depend; }

  int get_socket_number() { return socket_number; }

  void die();

  void quit_game();

  void server_cycle();

  // Observers

  // Add an observer to the list of player observers for this object
  void add_observer(PlayerObserver * observer);

  // Remove an observer from the list of player observers for this object
  void remove_observer(PlayerObserver * observer);


protected:
  char * _name;           // player name
  
  int    _number;         // player number
  
  int    _score;          // score of player
  int    _frag;           // number of times player died
  int    _best_length;    // maximum length player reached with a worm

  int    _depend;         // TRUE if this player uses the socket of
                          // another player.

  // Observers

  // Notify observers that the score just changed
  void notify_score_changed();

  // Notify observers that the best length just changed
  void notify_best_length_changed();

  DLList<PlayerObserver *>  _observers;

}; // class Player



#endif // __H_PLAYER__

