//==============================
// PlayerObserver.H
// 
// Public interface that must be implemented
// by objects wanting to be notified when a
// player is modified.
// 
// ZNibbles
// Vincent Mallet 1997, 1998, 1999
//==============================

// $Id: PlayerObserver.H,v 1.1 1999/05/10 23:44:05 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __H_PLAYEROBSERVER__
#define __H_PLAYEROBSERVER__

class Player;

class PlayerObserver {
public:

  // notification of player score change
  virtual void score_changed(Player& p) = 0;

  // notification of player best_length change
  virtual void best_length_changed(Player& p) = 0;


}; // class PlayerObserver


#endif // __H_PLAYEROBSERVER__

