//========================================
// ServerInterface.H
// 
// Server interface for ZNibbles
// 
// ZNibbles
// Vincent Mallet 1997
//========================================

// $Id: ServerInterface.H,v 1.5 1999/04/27 22:38:29 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_SERVERINTERFACE__
#define __H_SERVERINTERFACE__

#include "DLList.h" // Doubly linked lists

#include "BaseInterface.H"

#include "Common.H"
#include "Trame.H"

class Player;
class World;

class ServerInterface : public BaseInterface {
public:
  ServerInterface(World& wr);
  ~ServerInterface() { }

  void init(int argc, char *argv[]);    // init server interface
  void run();                           // run server 
  void end() { }                        // stops server (unused)
  
  void set_own_player(Player& p) { void *q = &p; q = q;}
  
  void add_player(Player& p) { void *x = &p; x = x; }
  void kill_player(Player& p, int reason) { void *x = &p; x = x; reason++; }
  
  void display_message(Player& from, char *msg, int priv);
  void display_system_message(char *msg,  Player *p = NULL, int color = 0);


  void display_version();          // display version numbers (long format)
  void display_version_short();    // display version number (short format)
  void display_help(char *name);   // display small help


protected:
  int            socket_ecoute;

  DLList<int>    pending_socket_list;
  int            nb_pending;
  unsigned long  ival; // interval in usec

  int            debug;

  static void pipe_handler(int sig);

  int accept_new(int socketnum);
  int handle_new_connection(int socketnum);

  void set_timer(int nbsecs);

}; // class ServerInterface


#endif // __H_SERVERINTERFACE__
