//====================================
// VoidInterface.H
//
// No interface.
//
// ZNibbles
// Vincent Mallet 1997, 1998
//====================================

// $Id: VoidInterface.H,v 1.5 1999/05/09 22:58:29 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_VOIDINTERFACE__
#define __H_VOIDINTERFACE__

#include "BaseInterface.H"

class VoidInterface : public BaseInterface {
public:
  inline VoidInterface(World &wr) : BaseInterface(wr) { }
  
  void init(int argc, char *argv[]) { argc++; argv--; }
  void run() { }
  void end() { }
  
  
  void set_own_player(Player& p) { void *q = &p; q = q;}
  
  void add_player(Player& p) { void *q = &p; q = q; }
  void kill_player(Player& p, int reason) { void *q = &p; q = q; reason++; }
  
  void display_message(Player& from, char *msg, int priv) { 
    void *q = &from; q = q; msg++; priv++; 
  }

  void display_system_message(char *msg, Player *p = 0, int color = 0) { 
    msg = (char *)p; color++; 
  }
  
}; // class VoidInterface


#endif // __H_VOIDINTERFACE__ 
