/*
 * NibblesArea.C
 *
 * L'area qui affiche la zone jouable de ZNibbles. Grande grille
 * sur laquelle evoluent les chenilles..
 *
 * Vincent Mallet 1997 - vmallet@clio.unice.fr
 */

// $Id: NibblesArea.C,v 1.6 1999/04/25 22:50:09 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "Map.H"
#include "X11Interface.H"

#include "NibblesArea.H"


// Constructor
NibblesArea::NibblesArea(X11Interface& _xif) : _map(NULL), _x(0), _y(0), known_colors(0), colors(NULL), xif(_xif), joined(False)
{ }

// Destructor
NibblesArea::~NibblesArea()
{
  if (_map) {
    for (int i = 0; i < _y; i++) 
      delete[] _map[i];
    delete[] _map;
  }

  if (colors)
    delete[] colors;
}


void NibblesArea::make2(int x, int y)
{
  _x = x;
  _y = y;
  
  _map = new char * [y];
  
  for (int i = 0; i < y; i++) 
    _map[i] = new char[x];

  clear();

  XResizeWindow(dpy, win, x * CELL_SIZE, y * CELL_SIZE);
}


void NibblesArea::clear()
{
  for (int i = 0; i < _y; i++)
    for (int j = 0; j < _x; j++) 
      _map[i][j] = '.';
}

void NibblesArea::draw_from_map(Map& map)
{
  //  win = XtWindow(draw);
  if (!win) 
    return;

  for (int i = _y - 1; i >= 0; i--)
    for (int j = _x - 1; j >= 0; j--) 
      draw_at(j, i, map._map[i][j]); 
}

void NibblesArea::redraw2(void)
{
  int x, y = 0;
  
  if (!win)
    return;

  for (int i = 0; i < _y; i++) {
    x = 0;
    for (int j = 0; j < _x; j++) {
      _draw_cell(j, i, x, y); 
      x += CELL_SIZE;
    }
    y += CELL_SIZE;
  } 
}


// mutante la fonction, bah, un gros switch.. 
// un jour on prendra le temps de faire plus joli.
inline void NibblesArea::_draw_cell(int x, int y, int sx, int sy)
{
  int color;
  int p = _map[y][x];

  if (p == '.') {
    XFillRectangle(dpy, win, gc_background, sx, sy, CELL_SIZEM1, CELL_SIZEM1);    
    return;
  }
  
  if (p >= 100) {
    color = p - 100;
    if (color < known_colors)
      color = colors[color];
    else
      color = 40960;
  }
  else {
    switch(p) {
    case 'D':
    case 'U':
    case 'L':
    case 'R':
    case 'B':
    case 'H':
    case 'G':
    case 'T':
      color = head_color;
      break;

    case 'S':
    case 'X':
      color = red_color;
      break;
      
    case '*':
      color = white_color;
      break;
      
    case 'x':
      color = 3040;
      break;
      
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      if (p < known_colors)
	color = colors[p];
      else
	color = yellow_color;
      break;
      
    default:
      color = background_color;
      break;
    }
  }
  

  XSetForeground(dpy, gc, color);

  if (p >= 100) {
    XFillRectangle(dpy, win, gc_background, sx, sy, CELL_SIZEM1, CELL_SIZEM1);    
    XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 0, 360 << 6);
  }
  else 
    switch(p) {
    case 'D':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 300 << 6, 300 << 6);
      break;
    case 'U':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 120 << 6, 300 << 6);
      break;
    case 'L':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 210 << 6, 300 << 6);
      break;
    case 'R':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 30 << 6, 300 << 6);
      break;
    case 'B':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 330 << 6, 240 << 6);
      break;
    case 'H':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 150 << 6, 240 << 6);
      break;
    case 'G':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 240 << 6, 240 << 6);
      break;
    case 'T':
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1, 60 << 6, 240 << 6);
      break;
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      XFillRectangle(dpy, win, gc_background, sx, sy, CELL_SIZEM1, CELL_SIZEM1);    
      sx++; sy++;
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1 - 2, CELL_SIZEM1 - 2, 0, 360 << 6);
      break;
    case 'S':
      {
	XFillRectangle(dpy, win, gc_background, sx, sy, CELL_SIZEM1, CELL_SIZEM1);    
	XPoint point[4];
	point[0].x = point[2].x = sx + (CELL_SIZEM1 >> 1);
	point[0].y = sy;
	point[1].x = sx + CELL_SIZEM1;
	point[1].y = point[3].y = sy + (CELL_SIZEM1 >> 1);
	point[2].y = sy + CELL_SIZEM1;
	point[3].x = sx;
	XFillPolygon(dpy, win, gc, point, 4, Convex, CoordModeOrigin);
      }
    break;
    case 'X':
      sx++; sy++;
      XFillArc(dpy, win, gc, sx, sy, CELL_SIZEM1 - 2, CELL_SIZEM1 - 2, 0, 360 << 6);
      break;
    default:
      XFillRectangle(dpy, win, gc, sx, sy, CELL_SIZEM1, CELL_SIZEM1);
      break;
    }
}




// void NibblesArea:: draw_exp_cb(Widget w, XtPointer client_data, XtPointer cbs)
// {
//   NibblesArea & mythis = * (NibblesArea *) client_data;

//   w = w; cbs = cbs; // warnings
    
//   mythis.redraw2();
// }


void NibblesArea::make(Window mywin, Display *display)
{

  win = mywin;


/*
  widget = draw   = XtVaCreateManagedWidget("NibblesAreaDraw", xmDrawingAreaWidgetClass, parent,
				   NULL);

  XtAddCallback(draw, XmNexposeCallback, draw_exp_cb, (XtPointer) this);

  XtAddEventHandler(draw, KeyPressMask, False, key_cb, this);   // pour les callbacks sur keyress

  dpy = XtDisplay(widget);
*/
  dpy = display;

  yellow_color = white_color = head_color = BlackPixel(dpy, DefaultScreen(dpy));

  get_GC(dpy, &gc);
  get_GC(dpy, &gc_background);
}


// a parametrer
void NibblesArea::set_config()
{
  XColor temp;
  XColor col;

  known_colors = 9;
  colors = new unsigned long [known_colors];

//   int bad = 0;
//   char s[50];
//   for (int i = 0; i < 255; i++) {
//     sprintf(s, "#%06x", i);
//     if (! XAllocNamedColor(dpy, DefaultColormapOfScreen(XtScreen(widget)), s, &col, &temp) )
//       bad++;
//   }
//   cout << "--bad=" << bad << endl;

  Colormap cmap = DefaultColormap(dpy, DefaultScreen(dpy));

  XAllocNamedColor(dpy, cmap, "#000040", &col, &temp);
  background_color = col.pixel;
  XSetForeground(dpy, gc_background, background_color);

  XAllocNamedColor(dpy, cmap, "#ffffff", &col, &temp);
  white_color = col.pixel;
  head_color = col.pixel;

  XAllocNamedColor(dpy, cmap, "Yellow", &col, &temp);
  yellow_color = col.pixel;

  XAllocNamedColor(dpy, cmap, "Red", &col, &temp);
  red_color = col.pixel;


  XAllocNamedColor(dpy, cmap, "#a000a0", &col, &temp);
  colors[0] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#00a0a0", &col, &temp);
  colors[1] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#aaaaaa", &col, &temp);
  colors[2] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#a00000", &col, &temp);
  colors[3] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#a0a000", &col, &temp);
  colors[4] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#00a000", &col, &temp);
  colors[5] = col.pixel;
  XAllocNamedColor(dpy, cmap, "Pink", &col, &temp);
  colors[6] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#0000ff", &col, &temp);
  colors[7] = col.pixel;
  XAllocNamedColor(dpy, cmap, "#00ff00", &col, &temp);
  colors[8] = col.pixel;


  redraw2();
}



// Cree le GC en Xcopy
void NibblesArea:: get_GC(Display *display, GC *gc_out)
{
  XGCValues values;
  unsigned long valuemask;

  valuemask         = GCFunction | /* GCPlaneMask | */ GCForeground |  GCLineWidth | GCFillStyle;

  values.function   = GXcopy;
  values.line_width = 4;
  values.fill_style = FillSolid;
  values.foreground = 0x101010;

  *gc_out = XCreateGC(display, RootWindow(display, DefaultScreen(display)), valuemask, &values);
}


void NibblesArea::nice_cursor(int shape)
{
    shape++; //@@ CHECK ME: for the warnings only
  //  :: nice_cursor(draw, shape);
}


// void NibblesArea::key_cb(Widget w, XtPointer client_data, XEvent *event, char *z)

void NibblesArea::handle_key(XEvent *event)
{
  XKeyPressedEvent & kevent = (XKeyPressedEvent &) * event;

   char buffer;
   int bufsize=1;
//    int charcount;
   KeySym ks;
  
//    charcount = 
   XLookupString(&kevent, &buffer, bufsize, &ks, NULL);

   switch(ks) {
   case XK_Down:
     xif.send_direction(D_DOWN);
     break;
   case XK_Up:
     xif.send_direction(D_UP);
     break;
   case XK_Left:
     xif.send_direction(D_LEFT);
     break;
   case XK_Right:
     xif.send_direction(D_RIGHT);
     break;
   case XK_p:
     xif.pause_request(PAUSE_GAME);
     break;
   case XK_u:
     xif.pause_request(UNPAUSE_GAME);
     break;
   case XK_P:
     xif.pause_request(PAUSE_OWN);
     break;
   case XK_U:
     xif.pause_request(UNPAUSE_OWN);
     break;
//   case XK_0:
//     mythis.xif.send_predefined_message(0);
//     break;
//   case XK_1:
//     mythis.xif.send_predefined_message(1);
//     break;
//   case XK_2:
//     mythis.xif.send_predefined_message(2);
//     break;
//   case XK_3:
//     mythis.xif.send_predefined_message(3);
//     break;
//   case XK_4:
//     mythis.xif.send_predefined_message(4);
//     break;
//   case XK_5:
//     mythis.xif.send_predefined_message(5);
//     break;
//   case XK_6:
//     mythis.xif.send_predefined_message(6);
//     break;
//   case XK_7:
//     mythis.xif.send_predefined_message(7);
//     break;
//   case XK_8:
//     mythis.xif.send_predefined_message(8);
//     break;
//   case XK_9:
//     mythis.xif.send_predefined_message(9);
//     break;
   default:
     printf("sym == %04x\n", (int) ks);
     break;
   }
}





