/*
 * NibblesArea.H
 *
 * L'area qui affiche la zone jouable de ZNibbles. Grande grille
 * sur laquelle evoluent les chenilles..
 *
 * Vincent Mallet 1997 - vmallet@clio.unice.fr
 */

// $Id: NibblesArea.H,v 1.3 1999/04/25 22:50:03 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998, 1999 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __H_NIBBLESAREA__
#define __H_NIBBLESAREA__


#include <X11/Xlib.h>

class X11Interface;
class Map;

#define CELL_SIZE   11
#define CELL_SIZEM1 11


class NibblesArea {

public:
  //  Widget widget;

  NibblesArea(X11Interface& xif);
  ~NibblesArea();
  void make(Window mywin, Display * display);
  void make2(int x, int y);
  //  void set_rightbutton_callback(XtCallbackProc proc, XtPointer client_data);
  
  void nice_cursor(int shape);
  void set_config();
  void set_text(char *text);

  void draw_at(int x, int y, int col);
  void draw_from_map(Map &map);
  void redraw2(void);
  void clear();
  void handle_key(XEvent *event);

private:
  char       **   _map; 
  int             _x;
  int             _y;

  int             known_colors;
  unsigned long * colors;
  
  X11Interface& xif;

  GC              gc;
  GC              gc_background;
  Display     *   dpy;

  //  Widget          draw;
  Window          win;

  unsigned long  head_color;
  unsigned long  background_color;
  unsigned long  white_color;
  unsigned long  yellow_color;
  unsigned long  red_color;

  int             joined;

  inline void _draw_cell(int x, int y, int sx, int sy);

  void get_GC(Display *display, GC *gc);

  //  static void draw_exp_cb(Widget w, XtPointer client_data, XtPointer cbs);
  //  static void key_cb(Widget w, XtPointer client_data, XEvent *event, char *z);
};



inline void NibblesArea::draw_at(int x, int y, int col)
{
  if (_map[y][x] != col) {
    _map[y][x] = col;
    _draw_cell(x, y, x * CELL_SIZE, y * CELL_SIZE);
  }
}



#endif // __H_NIBBLESAREA__





