/*
 * UserList.C
 *
 * Gere la liste qui contient le nom des utilisateurs
 * Herite de la classe AbsList
 *
 * Vincent Mallet 1997 - vmallet@clio.unice.fr
 */

// $Id: UserList.C,v 1.2 1998/11/17 08:43:07 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <Xm/Xm.h>
#include <Xm/List.h>

#include <stdio.h>

#include "UserList.H"


// createur
void UserList::make(Widget parent)
{
  widget = XmCreateScrolledList(parent, "FileScrolledList", NULL, 0);

  XtAddCallback(widget, XmNbrowseSelectionCallback, list_handler, (XtPointer) this);

  XtManageChild(widget);
}

// callback active quand on selectionne une entree de la liste
void UserList::list_handler(Widget w, XtPointer client_data, XtPointer cbs)
{
  w = w; // warnings...
  client_data = client_data;
  cbs = cbs;

  //  vimmail.set_active_message_file(((XmListCallbackStruct *)cbs)->item_position - 1);
}

// retire une entree de la liste
void UserList::remove_entry(char *name)
{
  XmListDeleteItem(widget, XmStringCreateLtoR(name, XmSTRING_DEFAULT_CHARSET));
}

